---
name: subscription-audit-automator
version: 1.0.0
---

# Initialization

Subscription Audit Automator helps individuals and organizations discover all their subscriptions across multiple sources (bank statements, emails, OAuth apps), analyze costs, identify waste, negotiate discounts, and track renewals automatically.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive subscription audit instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. The skill works standalone with any AI assistant.

Optional enhancements:
- Bank statement CSV exports for automated discovery
- Email access for receipt scanning
- Usage tracking data for better recommendations

## Post-Init Steps

### Claude Code
```bash
cp -r subscription-audit-automator/ ~/.claude/skills/subscription-audit-automator/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation
4. Start with your subscription data

### Quick Start
Provide the AI with:
- A list of your known subscriptions (name, cost, frequency)
- Bank/credit card statement export (CSV preferred)
- Your optimization goal (discover, reduce by X%, negotiate)

## Compatibility

Tested with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4 Turbo)
- Google Gemini
- GitHub Copilot Chat
- Any LLM with conversation capability

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{discovery_method}}` | `all` | Sources to use: bank_export, oauth_connect, email_scan, manual_entry |
| `{{negotiation_threshold}}` | `$500` | Minimum annual cost to pursue active negotiation |
| `{{renewal_alert_days}}` | `30, 15, 7` | Days before renewal to send alerts |
| `{{audit_frequency}}` | `quarterly` | How often to run comprehensive audits |
| `{{cost_per_user_threshold}}` | `$50` | Flag subscriptions exceeding this per-user cost |
| `{{min_utilization_percent}}` | `25` | Flag subscriptions below this usage percentage |

## Example Usage

**Personal Audit:**
```
I have subscriptions to Netflix, Spotify, Adobe CC, Notion, Calendly,
and a gym membership. Here's my Chase bank statement CSV. Can you:
1. Find any subscriptions I've forgotten
2. Calculate my total monthly spend
3. Tell me which ones to cancel or negotiate
4. Create negotiation scripts for the high-cost ones
```

**Enterprise SaaS:**
```
Our 50-person company pays for Asana, Monday, Jira, Trello, Slack,
Teams, and about 40 other tools. I have expense reports and SSO logs.
Help me:
1. Identify duplicate tools we can consolidate
2. Calculate cost per user across categories
3. Find unused licenses to reclaim
4. Prioritize negotiations by potential savings
```

## Key Features

- **Multi-source discovery**: Bank statements, email receipts, OAuth apps, app stores
- **Intelligent categorization**: Auto-groups by entertainment, productivity, services, etc.
- **Negotiation assistance**: Scripts, channel recommendations (phone 68% > chat 53% > email 41%)
- **Usage analysis**: Flags unused and underutilized subscriptions
- **Enterprise support**: Shadow IT discovery, license utilization, compliance trails
- **Continuous monitoring**: Renewal alerts, price increase tracking

## Research Sources

This skill was built using research from:
- Zluri SaaS Optimization Best Practices
- LicenseLogic Software Spend Framework
- SubCostCalculator Negotiation Tactics Guide
- CloudNuro SaaS Management Guide
- Enterprise subscription management platforms

---
Downloaded from [Find Skill.ai](https://findskill.ai)
