---
name: startup-idea-validation-sprint
version: 1.0.0
---

# Initialization

A comprehensive skill for validating startup ideas in 1-5 days using lean methodology. Guides entrepreneurs through customer discovery interviews, hypothesis testing, landing page experiments, and data-driven pivot or persevere decisions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete validation framework instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r startup-idea-validation-sprint/ ~/.claude/skills/startup-idea-validation-sprint/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{sprint_duration_days}}` | `5` | Total number of days for the validation sprint (1-5 days) |
| `{{interview_sample_size}}` | `15` | Target number of customer interviews to conduct |
| `{{budget_allocation_usd}}` | `500` | Total budget for validation activities |
| `{{landing_page_conversion_goal}}` | `email_capture` | Type of conversion to measure |
| `{{hypothesis_testing_iterations}}` | `3` | Number of test cycles before pivot/persevere decision |
| `{{target_customer_segment}}` | `early adopters in your target market` | Description of ideal customer profile |

## Core Capabilities

1. **Customer Discovery Interview Design** - Create interview guides, screener surveys, and structured question frameworks to understand customers deeply

2. **Hypothesis Testing Framework** - Map assumptions, prioritize by risk, formulate testable hypotheses, and design lean experiments

3. **Landing Page Validation** - Design value propositions, set conversion goals, run traffic tests, and interpret results against benchmarks

4. **Design Sprint Facilitation** - Guide teams through structured 5-day Map-Sketch-Decide-Prototype-Test sprints

5. **Pivot/Persevere Decision Support** - Review evidence objectively, analyze pivot options, and make data-driven strategic decisions

## Key Concepts Covered

- Build-Measure-Learn Cycle
- Minimum Viable Product (MVP)
- Problem-Solution Fit
- Product-Market Fit
- Validated Learning
- Van Westendorp Pricing
- Concierge MVP
- Customer Discovery
- Pivot Strategies

## Research Sources

This skill was developed using research from:
- Microsoft Learn: Validate Your Startup Idea
- Kromatic: Customer Discovery Interviews
- UXPin: Design Sprints methodology
- Kaizenko: Design Sprints for Product/Market Fit
- Bundl: Lean Validation Guide
- Growth Mentor: Pre-Launch Landing Page Validation
- Koombea: MVP Testing Strategies

## Example Usage

```
I'm building a SaaS tool for freelance project managers to track team
availability across multiple clients. Before building the full product,
I need to validate:

1) Freelance PMs actually struggle with availability tracking
2) They'd prefer a dedicated tool vs. spreadsheets or Asana
3) They'd pay $25-35/month for this solution

Run a 5-day validation sprint with:
- Customer discovery interview guide
- Landing page to test pricing
- Go/no-go threshold conversion rates
- Essential MVP features based on findings
- Final recommendation: build or pivot?

Budget: $400 | Timeline: 5 days | Team: 4 people
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
