---
name: social-media-boundaries-builder
version: 1.0.0
---

# Initialization

Social Media Boundaries Builder is an AI skill that helps users establish and maintain healthier relationships with social media platforms. It provides personalized strategies to manage notifications, reduce FOMO (Fear of Missing Out), combat comparison-driven anxiety, and create sustainable digital wellness habits using evidence-based techniques from CBT, mindfulness, and behavior science research.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for digital wellness coaching

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r social-media-boundaries-builder/ ~/.claude/skills/social-media-boundaries-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Digital Wellness Coach...")
3. Paste into your AI assistant as a system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Social Media Wellness Assessment (SMWA)** - Comprehensive evaluation of usage patterns, emotional impact, addiction indicators, FOMO levels, and comparison intensity with risk-level analysis

2. **FOMO Reduction Protocol (FoMO-R)** - Evidence-based framework including trigger identification, cognitive reframing scripts, batch-check scheduling, and JOMO (Joy of Missing Out) development

3. **Social Comparison Mitigation** - Strategic feed curation with unfollow/mute recommendations, content guidelines, and comparison resilience practices

4. **Notification Management** - Urgency categorization, platform-specific configuration guides, Do Not Disturb scheduling, and emergency contact allowlists

5. **Digital Detox Planning** - Structured offline periods from 24-hour challenges to 30-day resets with preparation checklists, activity schedules, and withdrawal management

6. **Work-Life Boundary Protection** - Time/space/communication boundary definition with technical implementation and scripts for managing colleague expectations

7. **Mindful Engagement Rituals** - Intention-setting protocols, purpose-driven use guidelines, structured check-in routines, and exit rituals

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{daily_screen_time_limit_minutes}}` | `120` | Total desired screen time for non-work social media per day |
| `{{batch_check_frequency_per_day}}` | `3` | Number of designated times to check social media |
| `{{focus_mode_start_time}}` | `20:00` | Time when notifications disable (24-hour format) |
| `{{focus_mode_end_time}}` | `08:00` | Time when notifications re-enable |
| `{{detox_intensity_level}}` | `moderate` | Aggressiveness of detox recommendation (gentle/moderate/aggressive) |
| `{{anxiety_sensitivity_level}}` | `medium` | User's susceptibility to notification anxiety (low/medium/high) |

## Research Foundation

This skill synthesizes findings from 10+ peer-reviewed sources including:
- Nature 2024 study on social media use patterns and youth mental health
- NIH research on FoMO reduction techniques
- Systematic reviews of technostress and mitigation strategies
- Evidence-based interventions using CBT and mindfulness approaches

---
Downloaded from [Find Skill.ai](https://findskill.ai)
