---
name: side-hustle-viability-scorer
version: 1.0.0
---

# Initialization

An objective evaluation framework using the ZENITH scoring methodology to assess side hustle opportunities across five dimensions: Essential Need, Net Income Potential, Implementation Speed, Time Sustainability, and High-Demand Frequency. Produces quantified 0-50 viability scores to help make data-driven decisions about which opportunities to pursue.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with the complete ZENITH framework, scoring guides, and assessment workflows

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r side-hustle-viability-scorer/ ~/.claude/skills/side-hustle-viability-scorer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Side Hustle Viability Scorer...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{income_requirement_monthly}}` | `1000` | Minimum monthly net income target in dollars |
| `{{available_hours_weekly}}` | `10` | Hours per week available for side hustle |
| `{{urgency_level}}` | `moderate` | How urgently income is needed (critical, high, moderate, low) |
| `{{life_situation}}` | `employed` | Current context (unemployed, employed, student, parent_primary, caregiver) |
| `{{risk_tolerance}}` | `moderate` | Comfort with uncertainty (low, moderate, high) |
| `{{geographic_zone_type}}` | `suburban` | Location type (urban, suburban, rural) |

## Key Features

### ZENITH Scoring Framework
- **E (Essential Need)**: How universal is the demand? (1-10)
- **N (Net Income)**: Realistic earnings after expenses? (1-10)
- **I (Implementation Speed)**: Time to first customer? (1-10)
- **T (Time Sustainability)**: Fits your current life? (1-10)
- **H (High-Demand Frequency)**: How often do customers need this? (1-10)

### Score Interpretation
- **40-50**: EXCELLENT - Launch immediately
- **35-39**: GOOD - Worth pursuing
- **30-34**: CAUTION - Address weaknesses first
- **25-29**: RISKY - Only with unusual advantages
- **Below 25**: NOT VIABLE - Pivot to different opportunity

### Additional Capabilities
- Zone Analysis for location-specific opportunity discovery
- Red flag detection and mitigation strategies
- Income projection with expense itemization
- Comparative analysis for multiple opportunities
- Minimal viable testing guidance

## Example Usage

```
User: "I'm thinking about starting a dog-walking service in my suburban
neighborhood. There are lots of young families and busy professionals
around. I have about 8 hours per week available and I'm currently
employed full-time. Can you score this opportunity?"

AI Response: Provides ZENITH assessment with dimension scores, total
viability rating, income projections, and first-week action plan.
```

## Related Skills

- Side Hustle Ideas Generator - Generate ideas to evaluate with this scorer
- Freelance Income Tracker - Track income from validated side hustles
- Business Plan Generator - Create plans for high-scoring opportunities
- Career Pivot Risk Calculator - Assess broader career change risks

---
Downloaded from [Find Skill.ai](https://findskill.ai)
