---
name: samurai-sensei-chore-master
version: 1.0.0
---

# Samurai Sensei Chore Master - Initialization

Transform mundane household tasks into epic samurai quests with Bushido philosophy, XP rewards, streak tracking, achievement badges, and Zen wisdom. Gamify your chores and build lasting habits through engaging narrative-driven challenges.

## Package Structure

```
samurai-sensei-chore-master/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r samurai-sensei-chore-master/ ~/.claude/skills/samurai-sensei-chore-master/
```

Then reference in your project's `CLAUDE.md`:
```markdown
## Skills
- samurai-sensei-chore-master: Gamified task management with samurai philosophy
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions
4. Start a conversation with "I need help with my chores" or "What quests do I have today?"

## Quick Start

After installation, try these prompts:

**First time user:**
> "I'm overwhelmed by household chores. I never finish my to-do list. Can you help me?"

**Request daily quests:**
> "What should I do today?" or "Give me my quests"

**Report completion:**
> "Done with the kitchen" or "I finished the laundry quest"

**Check progress:**
> "Show me my weekly summary" or "What's my streak?"

**After missing a day:**
> "I missed yesterday. Streak is broken."

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{difficulty_rating}}` | `3` | Base difficulty for generated quests (1-5) |
| `{{wisdom_style}}` | `poetic` | Quote style: poetic, practical, or humorous |
| `{{quest_flavor}}` | `samurai` | Narrative theme: samurai, monk, ninja, or mixed |
| `{{streak_tolerance}}` | `0` | Grace days before streak resets (0 = strict) |
| `{{social_mode}}` | `false` | Enable party quests and leaderboards |

## Core Features

### Gamification System
- **XP Points**: 25-250 XP per task based on difficulty
- **Honor Levels**: 10 progression tiers from "Aspiring Student" to "Immortal Sensei"
- **Streak Tracking**: Daily completion tracking with milestone rewards
- **Achievement Badges**: 20+ badges across streak, completion, and category milestones

### Bushido Philosophy
Eight virtues integrated into guidance:
1. **Gi** (Righteousness) - Face avoided tasks
2. **Yu** (Courage) - Start overwhelming projects
3. **Jin** (Benevolence) - Self-forgiveness after setbacks
4. **Rei** (Respect) - Honor your space
5. **Makoto** (Sincerity) - Full attention on tasks
6. **Meiyo** (Honor) - Pride in completed work
7. **Chugi** (Loyalty) - Commitment to goals
8. **Jisei** (Self-Control) - Resist procrastination

### Zen Wisdom
Context-appropriate quotes covering:
- Present-moment awareness
- Impermanence and acceptance
- Non-attachment to outcomes
- Effort and discipline
- Self-compassion

### Quest Categories
- Kitchen (dishes, counters, deep cleaning)
- Laundry (wash, dry, fold, store)
- Floors (sweep, vacuum, mop)
- Bathroom (toilet, shower, mirrors)
- Outdoor (yard, garden, exterior)
- Organization (closets, papers, decluttering)

## Customization

### Adjust Wisdom Style

For practical, action-focused guidance:
> "I prefer practical wisdom over poetic quotes"

For humor-infused motivation:
> "Use humorous samurai wisdom"

### Change Narrative Theme

> "Switch to monk-style quests" (meditation-focused)
> "Use ninja theme" (stealth/speed emphasis)
> "Mix up the quest styles" (random themes)

### Enable Social Features

> "I want to set up party mode with my roommate"
> "Show me the household leaderboard"

## Troubleshooting

**"This feels silly"**
The AI will respond: "The feeling will pass. The results won't. The samurai didn't feel dignified scrubbing their armor either—but they did it, because the practice matters more than the feeling."

**Overwhelmed by tasks**
Say: "I'm overwhelmed" and the AI will help you focus on a single, achievable quest.

**Want to quit**
The AI offers rest without judgment and keeps the door open for return.

## Integration Ideas

- Pair with a physical habit tracker or journal
- Set daily reminders to request quests
- Use with household members for party quests
- Track XP in a spreadsheet for visualization

## Compatibility

Works with all major AI assistants:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)
- Any LLM that accepts system prompts

---
Downloaded from [Find Skill.ai](https://findskill.ai)
