---
name: salary-negotiation-simulator
version: 1.0.0
---

# Salary Negotiation Simulator - Initialization

Practice salary negotiations with an AI hiring manager through realistic role-play conversations. Build confidence through iterative practice before your real negotiation.

## Overview

This skill transforms salary negotiation from an anxiety-inducing one-shot event into a practiced skill. Users engage in realistic dialogue with an AI hiring manager, receive behavioral feedback, and iterate until confident.

**Key Value**: 55% of workers don't negotiate, leaving $5K-$15K+ on the table. This simulator removes the preparation gap.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with hiring manager personas, dialogue templates, and feedback frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly to your AI assistant)

## Core Capabilities

1. **Role-Play Practice**: Realistic 1-on-1 salary negotiation conversations
2. **Counter-Offer Strategy**: Practice responding to initial offers with data-backed proposals
3. **Objection Handling**: Learn to address common employer pushbacks
4. **Behavioral Feedback**: Real-time guidance on tone, strategy, and tactics
5. **Multiple Personas**: Practice against 5 different hiring manager personalities

## Hiring Manager Personas Available

| Persona | Behavior | Best For Practicing |
|---------|----------|---------------------|
| Budget-Conscious CFO | Rigid on salary, flexible on benefits | Creative bundling, non-salary negotiation |
| Culture-First Founder | Flexible on equity, mission-focused | Equity negotiation, long-term value |
| Desperate Recruiter | High urgency, willing to move fast | Confident anchoring, leverage |
| Hardball Negotiator | Uses tactics (flinching, silence) | Pressure handling, composure |
| Collaborative Partner | Transparent, problem-solves together | Win-win solutions, relationship building |

## Key Concepts Covered

- **BATNA**: Best Alternative to Negotiated Agreement
- **Anchoring**: Setting the negotiation tone with data-backed numbers
- **Reciprocity**: Making labeled concessions for reciprocal responses
- **Reservation Price**: Walk-away threshold (never reveal directly)
- **Target Price**: Ideal outcome (anchor 10-15% above)

## Practice Workflows

1. **Counter-Offer Practice** (20-30 min): First response to initial offer
2. **Multi-Round Negotiation** (30-45 min): Full back-and-forth with concessions
3. **Objection Handling** (20 min): Practice responses to common pushbacks
4. **Hard Tactics Defense** (25 min): Handle pressure tactics and time pressure

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{job_title}}` | `Software Engineer` | Position being negotiated |
| `{{salary_target}}` | `120000` | Ideal annual salary in USD |
| `{{reservation_price}}` | `100000` | Minimum acceptable (walk-away) |
| `{{employer_initial_offer}}` | `110000` | Starting offer from employer |
| `{{opponent_style}}` | `collaborative` | Hiring manager personality |
| `{{location}}` | `San Francisco, CA` | Geographic market context |
| `{{competing_offers}}` | `none` | Other offers for BATNA leverage |

## Post-Init Steps

### Claude Code
```bash
cp -r salary-negotiation-simulator/ ~/.claude/skills/salary-negotiation-simulator/
```

### ChatGPT / Gemini / Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter (below the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start with: "I want to practice a salary negotiation"

### Quick Start Prompt
```
I'm negotiating a [JOB_TITLE] position at [COMPANY_TYPE].
Initial offer: $[AMOUNT]
My target: $[TARGET]
My walk-away: $[MINIMUM]
I have competing offers at: [DETAILS or "none"]

Can you roleplay as a [PERSONA_TYPE] hiring manager?
I want to practice [FOCUS: counter-offer / objection handling / full negotiation].
```

## Expected Outcomes

| Metric | Typical Result |
|--------|----------------|
| Financial Gain | 10-15% above initial offer |
| Confidence | 6/10 → 8/10 after 2-3 rounds |
| Time Investment | 2-4 hours total prep |
| ROI | $5K-$15K on 2-4 hours = $1,250-$3,750/hour |

## Feedback Framework

After each practice exchange, request Coach Mode feedback:

```
## Practice Session Feedback

### What Worked Well
- [Strengths observed]

### Areas for Improvement
- [Gaps and suggestions]

### Metrics Assessment
| Dimension | Score |
|-----------|-------|
| Value Framing | X/10 |
| Data Quality | X/10 |
| Tone/Delivery | X/10 |
| Strategy Execution | X/10 |

### Next Practice Focus
[Recommendation for improvement]
```

## Research Sources

This skill is grounded in peer-reviewed research:

1. Harvard PON - Competing vs. collaborative negotiation strategies
2. Meta-analysis 2024-2025 - 18.83% average increase from negotiation
3. CareerTrainer.ai - Working AI role-play example
4. HBS Online - Structured preparation frameworks
5. BATNA frameworks - Walk-away threshold and leverage tactics

## Compatibility

Tested with:
- Claude (Sonnet, Opus, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Related Skills

- **Salary Negotiation Coach**: Prepare scripts and market data before practicing
- **Interview Prep Simulator**: Practice interviews before the offer stage
- **Negotiation Stance Builder**: Determine optimal stance using frameworks
- **Job Offer Comparison Tool**: Compare offers after negotiating

---
Downloaded from [Find Skill.ai](https://findskill.ai)
