---
name: running-pace-pacer
version: 1.0.0
---

# Running Pace Pacer - Initialization

AI running coach for 5K training that calculates personalized training paces using the Jack Daniels VDOT methodology, creates structured weekly schedules, provides real-time workout feedback, and guides race-day strategy.

## What This Skill Does

- Calculates precise training paces (Easy, Tempo, VO2Max, Race) from goal time or recent race
- Generates weekly training schedules for 3-6 day programs
- Provides adaptive plan modifications based on workout performance
- Guides periodization through Base, Build, Peak, and Taper phases
- Offers race-day pacing strategy and pre-race preparation protocols
- Includes injury prevention strength and mobility routines

## Package Structure

```
running-pace-pacer/
├── SKILL.md      # Main skill prompt (500+ lines)
└── INIT.md       # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Extract to Claude Code skills directory
cp -r running-pace-pacer/ ~/.claude/skills/running-pace-pacer/

# Verify installation
ls ~/.claude/skills/running-pace-pacer/
```

### ChatGPT / Claude Web / Gemini

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter delimiter
3. Paste into a new conversation or custom GPT instructions
4. Start with your running goals

### Custom GPT Setup

1. Create new GPT at chat.openai.com/gpts
2. Name: "Running Pace Pacer" or "5K Training Coach"
3. Description: "Personalized 5K training with VDOT-calculated paces"
4. Instructions: Paste full SKILL.md content
5. Conversation starters:
   - "I want to run a sub-25 minute 5K in 10 weeks"
   - "Calculate my training paces from my recent 24:30 5K"
   - "What should this week's workouts look like?"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_5k_time}}` | `25:00` | Goal 5K finish time in MM:SS format |
| `{{fitness_level}}` | `intermediate` | Current fitness: beginner, intermediate, advanced |
| `{{days_per_week}}` | `4` | Training days available (3-6) |
| `{{current_easy_pace}}` | `9:30` | Comfortable easy running pace per mile |
| `{{weeks_to_race}}` | `8` | Weeks until target race |

## Quick Start

After installation, start with:

```
I'm training for my first 5K in [X] weeks. My goal is [time] and I can
train [X] days per week. What should my training paces be and what does
this week's schedule look like?
```

## Key Features

### VDOT Pace Calculator
Uses Jack Daniels' proven VDOT formula to calculate optimal training paces from race performance or goal times. Includes comprehensive lookup tables for 5K times from 15:00 to 40:00.

### Weekly Schedule Templates
Pre-built templates for:
- 3-day (beginner)
- 4-day (intermediate)
- 5-day (intermediate/advanced)
- 6-day (advanced)

### Training Periodization
Structured phases:
1. **Base Phase** (Weeks 1-4): Aerobic foundation
2. **Build Phase** (Weeks 5-8): Speed and threshold work
3. **Peak Phase** (Weeks 9-10): Race-specific sharpening
4. **Taper** (Final 1-2 weeks): Volume reduction for freshness

### Adaptive Modifications
Adjusts plans based on:
- Workout performance (crushed it / struggled)
- Missed sessions
- Fatigue or soreness reports
- Schedule conflicts

### Race Day Strategy
- Pre-race week protocols
- Mile-by-mile pacing strategy
- Mental preparation cues
- Nutrition and hydration guidance

## Sample Output

```
YOUR TRAINING PACES (Goal: 24:00 5K)
┌─────────────┬─────────────┬──────────────────────────────┐
│ Zone        │ Pace/Mile   │ Purpose                      │
├─────────────┼─────────────┼──────────────────────────────┤
│ Easy        │ 9:00-9:30   │ Recovery, aerobic base       │
│ Tempo       │ 7:50        │ Lactate threshold            │
│ VO2Max      │ 7:20        │ Interval training            │
│ Race Pace   │ 7:44        │ Goal 5K pace                 │
└─────────────┴─────────────┴──────────────────────────────┘

THIS WEEK'S SCHEDULE (Week 3 - Base Phase)
Mon: 4 mi easy + 4 strides
Wed: 2 mi WU + 4×800m @ 7:20 w/ 90sec jog + 1 mi CD
Fri: 2 mi WU + 2 mi tempo @ 7:50 + 1 mi CD
Sun: 6 mi long run
Total: ~19 miles
```

## Research Foundation

Based on proven methodologies from:
- Jack Daniels VDOT Running Formula
- Pete Riegel Race Prediction Formula
- Hal Higdon Training Plans
- 80/20 Running Principle (Dr. Stephen Seiler)
- TrainingPeaks periodization protocols

## Troubleshooting

**Paces feel too easy:**
Run current paces for 2 weeks to confirm, then recalculate with a faster goal time or recent race result.

**Paces feel too hard:**
Reduce goal time by 1-2 minutes, add extra rest day, or focus on easy runs until base fitness improves.

**Missing workouts:**
1 missed = skip and continue. 2+ missed = reduce next week's intensity. Full week missed = repeat previous week.

**Feeling fatigued:**
Insert immediate deload week (40% volume reduction). Monitor resting heart rate and sleep quality.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
