---
name: revenue-diversification-designer
version: 1.0.0
---

# Initialization

Revenue Diversification Designer helps businesses map alternative income streams while maintaining strategic focus. It identifies concentration risks, validates adjacent opportunities, designs revenue models, and creates phased implementation roadmaps—all while preserving brand identity and core competitive advantage.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for revenue diversification strategy

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r revenue-diversification-designer/ ~/.claude/skills/revenue-diversification-designer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Revenue Audit | Analyze current income sources and identify concentration risks |
| Opportunity Mapping | Identify 3-5 adjacent revenue options aligned with core competencies |
| Revenue Model Design | Select and structure optimal monetization approaches |
| Diversification Roadmap | Create phased implementation plans maintaining strategic focus |
| Portfolio Balancing | Optimize mix of revenue streams by growth, margin, and effort |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{revenue_concentration_threshold}}` | `60` | Percentage of revenue from single source triggering risk alert |
| `{{focus_boundary_scope}}` | `adjacent_market` | Acceptable diversification scope (core_only, adjacent_market, related_product, new_segment) |
| `{{time_to_profitability_constraint}}` | `12` | Maximum months to first profitable revenue |
| `{{minimum_effort_reduction_target}}` | `20` | Minimum efficiency gain percentage required for new stream |
| `{{customer_overlap_requirement}}` | `50` | Minimum percentage of customers that already buy core product |
| `{{gross_margin_floor}}` | `40` | Minimum acceptable gross margin percentage for new revenue stream |

## Example Usage

**SaaS Company with Customer Concentration:**
> "We're a mid-market project management SaaS with $2M ARR, but 65% comes from 8 enterprise accounts. What adjacent revenue streams should we explore that don't require building new features or significant hiring?"

**Consultant Building Passive Income:**
> "I'm a cybersecurity consultant earning $250K from project work but burned out. How can I build passive income streams to reach $400K without losing my reputation?"

**E-Commerce Brand Seeking Stability:**
> "We're a D2C fitness apparel brand doing $5M in product sales with 50% margins. We're seasonal and ad-dependent. What revenue streams could improve resilience?"

## Key Frameworks Used

- **Ansoff Matrix**: Categorizes growth strategies by market/product risk
- **Porter's Focus Strategy**: Maintains competitive advantage through specialization
- **Business Model Canvas**: Maps all 9 blocks for revenue stream integration
- **BCG Matrix**: Categorizes streams as stars, cash cows, question marks, dogs

## Industry Patterns Included

| Industry | Recommended Revenue Mix |
|----------|------------------------|
| SaaS | Subscription + usage-based + professional services |
| B2B Services | Core services + retainer + productized + affiliate |
| E-Commerce/D2C | Direct sales + subscription + affiliate + advertising |
| Content/Media | Subscriptions + advertising + sponsorships + affiliate |
| Professional Individual | Core service + retainer + courses + affiliate |
| Nonprofit | Grants + donations + corporate partnerships + earned revenue |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
