---
name: remote-worker-isolation-action-plan
version: 1.0.0
---

# Initialization

Combat remote worker loneliness and isolation with evidence-based action plans. This skill provides personalized isolation assessments, belonging plan frameworks for managers, communication protocol design for teams, and introvert-friendly connection strategies—all built on academic research showing co-worker support has a 4.06x protective factor against isolation.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive workflows for individuals, managers, and HR leaders

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r remote-worker-isolation-action-plan/ ~/.claude/skills/remote-worker-isolation-action-plan/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{isolation_risk_threshold}}` | `6` | Score (1-10) above which to flag employee as at-risk |
| `{{optimal_group_size}}` | `3-4` | Recommended group size for recurring interactions |
| `{{minimum_interaction_frequency}}` | `weekly` | Baseline frequency for meaningful connection touchpoints |
| `{{check_in_interval}}` | `30` | Days between automated follow-ups on action plan progress |
| `{{introvert_energy_recovery_time}}` | `24` | Hours recommended between high-intensity social events |

## Core Workflows

1. **Individual Isolation Assessment** - 12-question diagnostic generating personalized 30-day action plans
2. **Manager Belonging Plan** - Framework for proactively connecting new hires or at-risk employees with 3-5 matched colleagues
3. **Team Communication Protocol** - Design channel taxonomy, response time norms, and introvert-friendly meeting cadences
4. **Introvert Strengths Mapping** - Identify high-value contribution pathways that leverage introvert capabilities

## Research Foundation

Built on 10 academic and practitioner sources (2020-2025) including:
- Systematic reviews using Job Demands-Resources (JD-R) model
- Cross-sectional study of 4,052 workers showing 4.06x co-worker support multiplier
- SEM analysis of organizational support as mediator for psychological well-being

---
Downloaded from [Find Skill.ai](https://findskill.ai)
