---
name: remote-work-relocation-analyzer
version: 1.0.0
---

# Remote Work Relocation Analyzer - Initialization

A quantified decision engine for remote workers evaluating relocation destinations through weighted scoring algorithms, trade-off matrices, and scenario modeling across cost, visa, lifestyle, and career factors.

## What This Skill Does

This skill transforms the complex "where should I relocate?" decision into a data-driven analysis with:
- **Multi-factor city scoring** using weighted algorithms across 7 dimensions
- **Trade-off matrices** showing explicit gains/losses between destinations
- **Salary-to-lifestyle optimization** with purchasing power calculations
- **Visa & tax strategy analysis** including FEIE, treaties, and 183-day rules
- **Scenario modeling** for career vs. lifestyle decisions

## Structure

```
remote-work-relocation-analyzer/
├── SKILL.md   # Main skill prompt (use this)
└── INIT.md    # This file (setup instructions)
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r remote-work-relocation-analyzer/ ~/.claude/skills/remote-work-relocation-analyzer/
```

Then reference in your CLAUDE.md:
```markdown
## Available Skills
| Skill | Location | Use When |
|-------|----------|----------|
| `remote-work-relocation-analyzer` | `~/.claude/skills/remote-work-relocation-analyzer/` | Evaluating remote work relocation options with quantified analysis |
```

### For ChatGPT/Gemini/Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions
4. Start with: "I want to analyze remote work relocation options"

### For Claude Projects

1. Upload `SKILL.md` to your Claude Project knowledge base
2. The skill will be available in all conversations within that project

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `weight_cost_living` | `7` | Emphasis on affordability (0-10 scale) |
| `work_intensity` | `3` | Timezone collaboration needs (1=async, 5=real-time) |
| `visa_duration_preferred` | `12` | Minimum visa duration in months |
| `monthly_budget_usd` | `2500` | Maximum monthly living expenses |
| `quality_of_life_priorities` | `safety, healthcare, community` | Ranked factors for weighting |
| `family_friendly` | `false` | Include family visa/school considerations |

## Quick Start Prompts

After installing, try these example prompts:

**City Comparison:**
```
Compare Lisbon, Chiang Mai, and Mexico City for a $4,000/month remote worker.
Weight cost at 7/10, community at 8/10, safety at 9/10.
```

**Burnout Sabbatical:**
```
I'm burned out and have $1,500/month budget for a 6-month wellness sabbatical.
Find me destinations with yoga communities and nature access.
```

**Career Trade-Off:**
```
I got a job offer that pays $95k but requires moving from NYC to Austin.
Current job is $75k in NYC. Run a career vs. lifestyle trade-off analysis.
```

**Tax Optimization:**
```
I earn $60k/year as a US freelancer. What's my best visa/tax strategy
to minimize taxes over 3 years while living abroad?
```

## Related Skills

Use these complementary skills for a complete relocation journey:

- **Remote Work Location Strategy** - Strategic guidance (vs. this skill's quantified analysis)
- **Relocation Regret Minimizer** - Pre-move stress-testing after identifying candidates
- **Career Pivot Risk Calculator** - When combining job change with relocation
- **Budget Planner** - Create detailed budgets for your new destination
- **Tax Prep Assistant** - Organize expat tax documents after relocating

## Troubleshooting

**"Scores don't match my intuition"**
→ Adjust your priority weights. The algorithm reflects YOUR priorities - if cost matters more than you initially said, increase `weight_cost_living`.

**"Missing visa information for [country]"**
→ Visa programs change frequently. The skill provides frameworks; verify current requirements on official government websites.

**"Tax advice seems generic"**
→ This skill provides frameworks and scenarios, not legal advice. Always confirm with an expat-focused CPA for your specific situation.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
