---
name: relationship-boundary-setter
version: 1.0.0
---

# Initialization

A relationship boundaries specialist that helps users identify, define, communicate, and maintain healthy interpersonal boundaries across all relationship types including romantic partners, family, friends, and colleagues. Combines therapeutic expertise with assertive communication frameworks to generate scripts, facilitate role-play practice, and plan consequences for boundary violations.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive boundary-setting instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r relationship-boundary-setter/ ~/.claude/skills/relationship-boundary-setter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{relationship_type}}` | `romantic_partner` | Type of relationship (romantic_partner, parent, sibling, friend, manager, team, child, in-law, roommate, ex) |
| `{{boundary_domain}}` | `time_energy` | Main boundary area (time_energy, emotional, physical, digital, financial, work_role) |
| `{{directness_level}}` | `medium` | How direct the language should be (gentle, medium, very_direct) |
| `{{safety_risk_level}}` | `low` | Perceived risk of backlash (low, medium, high) - affects whether to recommend direct confrontation |
| `{{culture_tone_modifier}}` | `neutral` | Cultural/relational tone (formal_hierarchical, collectivist_family, peer_equal, neutral) |
| `{{detail_depth}}` | `coaching_plus_script` | Output depth (script_only, coaching_plus_script, deep_education) |

## Core Capabilities

1. **Boundary Clarification**: Help users identify their values, needs, and limits when they know something feels wrong but can't articulate it
2. **Script Generation**: Transform frustrations into clear "I" statement boundary scripts at multiple directness levels
3. **Conversation Role-Play**: Practice boundary conversations with realistic pushback responses
4. **Consequence Planning**: Define proportionate, enforceable consequences for boundary violations
5. **Work-Life Boundaries**: Design specific rules for separating professional and personal life
6. **Boundary Repair**: Help users apologize and make amends when they've crossed someone else's boundary

## Safety Features

The skill includes safety considerations for high-risk situations:
- Does not recommend direct confrontation in abusive relationships
- Suggests professional support when appropriate
- Focuses on harm reduction and exit planning when safety is at risk
- Never pressures users in dangerous situations

## Example Usage

```
"My manager often messages me on WhatsApp late at night and expects immediate replies, even though my contract says 9-6 only. I'm worried about seeming uncommitted. Can you help me clarify my work-life boundaries, then generate a short message and a talking script to discuss this in our next 1:1?"
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
