---
name: rabbit-hole-mapper
version: 1.0.0
---

# Initialization

Transform obsessive interests into structured learning journeys. The Rabbit Hole Mapper generates personalized knowledge maps, spaced repetition schedules, and progressive pathways for any topic using pedagogical frameworks like Bloom's Taxonomy and scientifically-backed retention strategies.

## Structure

- `SKILL.md` - Main skill prompt with complete learning path generation methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r rabbit-hole-mapper/ ~/.claude/skills/rabbit-hole-mapper/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# RABBIT HOLE MAPPER")
3. Paste into AI assistant as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `learning_pace` | `moderate` | Controls content density and review frequency (slow/moderate/fast) |
| `preferred_formats` | `video, interactive, hands-on` | Learner's preferred content types |
| `daily_commitment_minutes` | `45` | Daily time available for learning |
| `mastery_threshold` | `80` | Percentage correct needed to mark concept as mastered |
| `review_intervals_days` | `1, 3, 7, 14, 30, 60` | Spacing schedule based on spaced repetition research |
| `specialization_focus` | `general` | Depth axis: general (broad overview) vs specialized (deep dive) |
| `practical_emphasis` | `50` | 0-100 scale balancing theory vs hands-on projects |

## Usage Examples

### Basic Topic Exploration
```
I want to deeply understand [TOPIC]. I'm a complete beginner but fascinated by it.
Create a learning map that shows me what I need to learn and in what order.
```

### With Specific Constraints
```
I want to learn [TOPIC]. I have 30 minutes per day, prefer video content,
and want to reach a level where I can [SPECIFIC GOAL] within 3 months.
```

### Spaced Repetition Focus
```
I've been learning [TOPIC] for a few weeks but keep forgetting what I studied.
Create a 60-day spaced repetition schedule for the key concepts I need to retain.
```

### Project-Based Learning
```
I want to learn [TOPIC] by building things. Design a series of progressively
harder projects that will take me from beginner to intermediate in 8 weeks.
```

## Key Features

1. **Topic Decomposition** - Breaks any complex topic into foundational concepts, building blocks, and advanced areas

2. **Learning Path Generation** - Creates multi-stage pathways (Beginner → Intermediate → Advanced → Expert)

3. **Spaced Repetition Scheduling** - Generates review schedules aligned with the forgetting curve

4. **Knowledge Graph Visualization** - Maps topic relationships and prerequisites

5. **Project-Based Milestones** - Designs hands-on challenges at each stage

6. **Adaptive Recommendations** - Adjusts difficulty/pacing based on learner performance

## Best For

- Self-directed learners pursuing passion projects
- Hobbyists seeking deep expertise in niche domains
- Students supplementing formal education
- Career pivoters learning new fields
- Content creators building expertise to teach

---
Downloaded from [Find Skill.ai](https://findskill.ai)
