---
name: protein-optimization-calculator
version: 1.0.0
---

# Initialization

AI-powered protein optimization calculator for athletes and fitness enthusiasts. Calculates personalized daily protein intake based on training phase, body composition, dietary preferences (including vegan optimization), and muscle protein synthesis timing.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive protein optimization instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r protein-optimization-calculator/ ~/.claude/skills/protein-optimization-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert sports nutrition specialist...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{body_weight_kg}}` | `75` | Total body weight in kilograms |
| `{{training_goal}}` | `muscle_gain` | Primary fitness objective (muscle_gain, fat_loss, maintenance, endurance, strength) |
| `{{dietary_preference}}` | `omnivore` | Dietary type: omnivore, vegetarian, or vegan |
| `{{training_phase}}` | `hypertrophy` | Current periodization phase |
| `{{meal_frequency}}` | `4` | Preferred number of daily meals (3-6) |

## Quick Start

After installation, try these prompts:

**Basic Calculation:**
"I'm 80kg, training 4 days a week for muscle gain. I'm omnivore. What's my optimal daily protein intake?"

**Vegan Athlete:**
"I'm a 65kg vegan female, running 5 days/week plus 2 strength sessions. I want to improve my 10K time while maintaining muscle. Help me optimize my protein intake."

**Phase Transition:**
"I've been bulking at 2.0g/kg protein for 12 weeks. Now I'm transitioning to a cutting phase. How should I adjust my protein and meal timing?"

**Troubleshooting:**
"I'm eating 180g protein daily but my strength gains have stalled. I'm 85kg and train 5 days a week. What might be wrong?"

## Features

- Evidence-based calculations (ISSN, ACSM guidelines)
- Lean body mass estimation
- Goal-specific multipliers (muscle gain, fat loss, endurance, strength)
- Vegan/vegetarian adjustments (+10-20%)
- Training phase periodization
- Meal distribution planning (MPS optimization)
- Post-workout and pre-sleep timing
- Protein source quality rankings
- Progress tracking and adjustment protocols
- Troubleshooting common issues

---
Downloaded from [Find Skill.ai](https://findskill.ai)
