---
name: property-investment-fundamentals
version: 1.0.0
---

# Initialization

Evaluate rental properties as investments using professional-grade financial analysis. Calculate cap rates, cash-on-cash returns, IRR, tax benefits, and compare returns to stocks, bonds, and REITs.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive property investment analysis instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r property-investment-fundamentals/ ~/.claude/skills/property-investment-fundamentals/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{purchase_price}}` | `$300,000` | Property acquisition cost |
| `{{down_payment_percent}}` | `25%` | Percentage of purchase price paid upfront |
| `{{loan_interest_rate}}` | `6.5%` | Annual mortgage interest rate |
| `{{annual_rental_income}}` | `$24,000` | Gross annual rent (before vacancy) |
| `{{operating_expense_ratio}}` | `40%` | Expenses as percentage of gross rent |
| `{{appreciation_rate}}` | `3%` | Expected annual property value growth |

## Core Capabilities

1. **Financial Metric Analysis**: Calculate cap rate, NOI, cash-on-cash return, IRR, NPV, DSCR
2. **Cash Flow Modeling**: Project rental income, operating expenses, and net cash flow
3. **Tax Benefit Quantification**: Calculate depreciation deductions and pass-through benefits
4. **Property Comparison**: Evaluate multiple properties side-by-side with standardized metrics
5. **BRRRR Strategy Analysis**: Model capital recycling and forced appreciation scenarios
6. **Investment Alternative Assessment**: Compare real estate returns to stocks, bonds, REITs

## Example Usage

```
"I'm comparing two rental properties in Austin, TX. Property A: $450k purchase
price, estimated $3,800/month rent, 40% expense ratio, 25% down. Property B:
$520k, estimated $4,200/month rent, 45% expense ratio, 20% down. Both have
6.5% mortgage rates. Which is the better investment?"
```

## Key Concepts Reference

- **Net Operating Income (NOI)**: Gross rental income minus operating expenses (excluding debt service)
- **Cap Rate**: NOI divided by purchase price; unleveraged return metric
- **Cash-on-Cash Return**: Annual cash flow divided by total cash invested
- **Internal Rate of Return (IRR)**: Annualized return accounting for all cash flows over time
- **DSCR**: NOI divided by debt service; measures ability to cover loan payments
- **Depreciation**: Non-cash tax deduction (27.5 years for residential)
- **BRRRR**: Buy, Rehab, Rent, Refinance, Repeat strategy for capital recycling

---
Downloaded from [Find Skill.ai](https://findskill.ai)
