---
name: product-comparison-creator
version: 1.0.0
---

# Product Comparison Creator - Initialization

Generate professional comparison tables, feature matrices, pricing comparisons, and sales battle cards that position your product against competitors with data-driven clarity.

## Package Structure

```
product-comparison-creator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r product-comparison-creator/ ~/.claude/skills/product-comparison-creator/
```

Then reference in your conversations or CLAUDE.md:
```
Use the product-comparison-creator skill for competitive analysis.
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin comparing products

## Quick Start

After installing, try this prompt:

```
Generate a feature comparison table for my CRM "AcmeCRM" versus
HubSpot, Pipedrive, and Zoho CRM. Focus on pipeline management,
reporting, email integration, and automation. Target audience is
SMB sales teams.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{your_product}}` | `Your Product Name` | Name of your product to compare |
| `{{competitors}}` | `Competitor A, Competitor B, Competitor C` | Comma-separated competitor list |
| `{{target_segment}}` | `SMB SaaS companies` | Target customer segment |
| `{{comparison_type}}` | `feature` | Type: feature, pricing, battle-card, landscape, sentiment |
| `{{max_features}}` | `15` | Maximum features per comparison table |

## Comparison Types Available

1. **Feature Matrix** - Side-by-side feature comparison with symbols
2. **Pricing Table** - Normalized pricing comparison with scenarios
3. **Sales Battle Card** - One-page competitive enablement document
4. **Market Landscape** - Category positioning with clusters
5. **Voice-of-Customer** - Sentiment-based qualitative comparison
6. **Website Comparison** - SEO-optimized "X vs Y" page content

## Example Outputs

### Feature Matrix Format
```
| Feature | Your Product | Competitor A | Competitor B |
|---------|--------------|--------------|--------------|
| Feature 1 | ✅ Full | ⚠️ Limited | ❌ None |
| Feature 2 | ✅ Full | ✅ Full | 💰 Add-on |
```

### Battle Card Format
```
# Battle Card: Your Product vs Competitor

## When We Win
- [Differentiator 1]
- [Differentiator 2]

## Common Objections
**"They have X feature"**
→ [Response]
```

## Best Practices

1. **Start with context** - Provide your product name, category, and target segment
2. **Limit competitors** - Compare 3-7 competitors per table for readability
3. **Specify audience** - Internal, sales team, or external/website use
4. **Request specific types** - Ask for feature matrix, pricing, or battle card explicitly
5. **Verify data** - AI may not have current pricing; verify before publishing

## Related Skills

- **Competitive Analysis Framework** - SWOT and Porter's Five Forces analysis
- **Pricing Strategy Optimizer** - Optimize your pricing based on competition
- **Go-to-Market Strategy Creator** - Build GTM informed by competitive position
- **Pitch Deck Creator** - Create decks with competitive positioning slides

## Troubleshooting

**AI doesn't know current competitor pricing**
→ Provide pricing data in your prompt or ask for a template to fill in

**Table too wide for display**
→ Request split tables or reduce competitors to 3-4 per table

**Need more detail on specific competitor**
→ Request a dedicated battle card for that competitor

---
Downloaded from [Find Skill.ai](https://findskill.ai)
