---
name: pod-product-descriptions
version: 1.0.0
---

# Initialization

Create SEO-optimized product descriptions for Redbubble, Merch by Amazon, Printful, and other POD platforms. Master tags, titles, and design-focused copy.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r pod-product-descriptions/ ~/.claude/skills/pod-product-descriptions/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{platform}}` | `Redbubble` | POD platform (Redbubble, Merch by Amazon, Printful, Etsy) |
| `{{design_description}}` | - | Description of the design/artwork |
| `{{niche}}` | `general` | Target niche or theme |
| `{{product_types}}` | `t-shirts, stickers, mugs` | Products the design will appear on |
| `{{target_audience}}` | `general consumers` | Who would buy this design |
| `{{style}}` | `modern` | Design style (minimalist, vintage, bold, etc.) |

---
Downloaded from [Find Skill.ai](https://findskill.ai)