---
name: pricing-strategy-optimizer
version: 1.0.0
---

# Initialization

Data-driven pricing optimization framework using elasticity analysis, dynamic repricing rules, customer segmentation, and fairness perception assessment. Helps users maximize revenue while maintaining customer trust through quantitative demand modeling and strategic pricing decisions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive pricing optimization instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r pricing-strategy-optimizer/ ~/.claude/skills/pricing-strategy-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_category}}` | `electronics` | Product category for baseline elasticity assumptions |
| `{{price_sensitivity_elasticity}}` | `-0.8` | Price elasticity coefficient (-0.1 to -2.0+) |
| `{{competitor_price_weight}}` | `0.4` | Weight of competitive pricing in recommendations (0-1) |
| `{{fairness_perception_risk_threshold}}` | `0.6` | Risk threshold triggering fairness assessment (0-1) |
| `{{margin_floor_percent}}` | `25` | Minimum acceptable profit margin percentage |
| `{{dynamic_pricing_frequency}}` | `daily` | Repricing frequency: hourly/daily/weekly/monthly |
| `{{customer_segment_count}}` | `3` | Number of customer segments for personalized pricing |
| `{{price_change_max_magnitude}}` | `15` | Maximum percentage price change per cycle |
| `{{transparency_level}}` | `medium` | Pricing transparency: high/medium/low |

## Core Capabilities

1. **Price Elasticity Analysis** - Calculate demand sensitivity using regression models
2. **Van Westendorp PSM** - Survey-based methodology for acceptable price ranges
3. **Dynamic Pricing Optimization** - Automated repricing rules with guardrails
4. **Customer Segmentation** - Tier-based personalized pricing strategies
5. **Competitive Intelligence** - Monitor and respond to competitor pricing
6. **Fairness Assessment** - Evaluate perception risks and communication strategies

## Example Usage

```
I'm launching a new smart home automation hub competing with Philips Hue ($129),
LIFX ($99), and Amazon Echo ($89). Manufacturing costs are $35/unit with target
50% margins. My Van Westendorp survey of 250 customers shows acceptable range
of $90-$150. Should I skim at premium or penetrate at value? What's my optimal
launch price and how should I communicate it?
```

## Research Sources

- The Latest Pricing Trends in 2024 (4pricing.pro)
- A Systematic Literature Review of Dynamic Pricing Strategies (CCSENET)
- Van Westendorp Pricing Sensitivity Meter (Sawtooth Software)
- Dynamic Pricing: Strategy and Consumer Perception (Forbes)
- Top 7 Tools for Price Elasticity Analysis 2025 (Growth-onomics)
- Consumer Perception of Price Fairness (ScienceDirect)
- Top Five Pricing Best Practices To Drive Revenue (Forbes)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
