---
name: personal-tax-strategy-planner
version: 1.0.0
---

# Personal Tax Strategy Planner - Initialization

Generate personalized year-end tax optimization strategies analyzing income, investments, retirement accounts, and deductions to maximize savings before December 31st.

## Overview

This skill transforms you into an expert tax strategy advisor for high-income individuals ($100K-$1M+). It provides:

- **Year-End Deduction Audits**: Standard vs. itemized analysis, bunching strategies
- **Tax-Loss Harvesting**: Portfolio review, wash-sale compliance, timing
- **Charitable Bunching**: Donor-Advised Funds, appreciated securities, QCDs
- **Retirement Optimization**: 401(k), IRA, HSA, SEP, Solo 401(k) strategies
- **Income Timing**: Acceleration vs. deferral decisions
- **Multi-Year Planning**: Roth conversions, RMD planning, IRMAA avoidance
- **AMT Risk Assessment**: ISO exercise strategies, credit recovery

## Structure

```
personal-tax-strategy-planner/
├── SKILL.md    # Main skill prompt (use this)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r personal-tax-strategy-planner/ ~/.claude/skills/personal-tax-strategy-planner/

# Add to your project's .claude/settings.json
{
  "skills": ["personal-tax-strategy-planner"]
}
```

### For ChatGPT/Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your Custom GPT's instructions

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire prompt content
3. Paste at the beginning of your conversation or into system instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{filing_status}}` | `married_filing_jointly` | Tax filing status (single, MFJ, MFS, HOH) |
| `{{annual_income}}` | `$150,000` | Projected total income from all sources |
| `{{investment_portfolio_value}}` | `$500,000` | Current taxable brokerage account value |
| `{{charitable_giving_annual}}` | `$10,000` | Typical annual charitable donations |
| `{{marginal_tax_rate}}` | `24%` | Estimated federal marginal tax rate |
| `{{age}}` | `45` | Current age (affects catch-up limits, RMD timing) |

## Key 2025 Tax Numbers Referenced

| Item | Limit |
|------|-------|
| 401(k) contribution | $23,500 ($31,000 with catch-up) |
| IRA contribution | $7,000 ($8,000 with catch-up) |
| HSA family contribution | $8,550 |
| Standard deduction (MFJ) | $31,500 |
| SALT cap | $40,000 |
| Capital loss deduction | $3,000/year |
| QCD limit (age 70.5+) | $105,000 |

## Example Usage

```
I'm a 52-year-old tech employee with $220K salary, $80K in RSU vesting
this year, and $45K in unrealized losses in my brokerage account. I have
$800K in my 401(k) and $200K in a Traditional IRA. I donate about $15K/year
to charity. What tax optimization strategies should I implement before year-end?
```

## Best Practices

1. **Gather complete data first** - The skill works best with full financial picture
2. **Run in October-November** - Allows time to implement strategies
3. **Document all decisions** - For next year's planning and tax preparer
4. **Review with CPA** - Complex strategies (AMT, Roth conversions) need professional review
5. **Update annually** - Tax law changes affect strategy recommendations

## Related Skills

- **Tax Planning Basics** - Foundational tax education
- **Tax Deduction Auditor** - IRS compliance review
- **Retirement Planner** - Long-term retirement strategy
- **Investment Analyzer** - Portfolio evaluation
- **Quarterly Tax Estimator** - Estimated payment calculations

## Disclaimer

This skill provides educational guidance only. Tax laws change annually and individual circumstances vary. Always consult with a qualified CPA or tax professional before implementing any tax strategy.

---

Downloaded from [Find Skill.ai](https://findskill.ai)
