---
name: personal-brand-clarity-session
version: 1.0.0
---

# Initialization

A structured self-discovery and positioning workshop that helps professionals define their unique niche, articulate their authentic value proposition, and establish clear positioning without falling into the "everything to everyone" trap.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive personal branding methodology

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r personal-brand-clarity-session/ ~/.claude/skills/personal-brand-clarity-session/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Personal Brand Strategist...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

This skill enables:

1. **Niche Definition & Market Positioning** - Identify specific market segment to dominate with strategic exclusion
2. **Unique Value Proposition (UVP) Clarification** - Articulate what distinctly differentiates you from alternatives
3. **Target Audience Profiling** - Deep understanding of who you serve, their pain points, and values
4. **Brand Equity Assessment** - Evaluate credentials, networks, cultural capital, and personality assets
5. **Positioning Statement Development** - Craft strategic statements guiding consistent messaging
6. **Authentic Brand Narrative Building** - Develop compelling stories showcasing genuine values
7. **Perception Gap Analysis** - Compare desired vs. actual perception and close alignment gaps

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{session_duration}}` | `90 minutes` | Time allocated for session (60/90/120 min options) |
| `{{brand_maturity_level}}` | `Early Stage` | Current brand development stage (Early/Developing/Established) |
| `{{primary_niche}}` | `User-defined` | Specific market segment to own |
| `{{differentiation_angle}}` | `User-defined` | Unique angle type (methodology/perspective/experience/values/audience) |
| `{{feedback_sample_size}}` | `5-7 people` | Number of "truthtellers" for perception feedback |

## Key Frameworks Included

### Harvard Business School Brand Equity Model
- Credentials Capital
- Social Capital
- Cultural Capital
- Physical/Visual Capital
- Personality Capital

### 4Cs of Personal Branding
- Clarity
- Consistency
- Content
- Connection

### Positioning Statement Template
"For [target audience] who [need], [Name] provides [solution] because [credibility]. Unlike [alternatives], I [differentiator]."

## Workflows Supported

1. **Personal Brand Clarity Discovery Session** (90 min) - Full clarity session for new positioning
2. **Positioning Statement & Messaging Development** (60 min) - Focused positioning work
3. **Personal Brand Audit & Perception Gap Analysis** (2-3 weeks) - Current state assessment
4. **Niche Validation & Audience Fit Assessment** (60 min) - Validate niche viability
5. **Authentic Brand Narrative Development** (75 min) - Build compelling brand stories

## Example Usage

```
"I've been a senior software engineer for 8 years and want to transition into
tech leadership. I have strong technical depth, mentoring experience, and I'm
passionate about building inclusive engineering cultures. But I see other
engineering leaders online who seem to do similar things. How do I figure out
my unique positioning? Should I focus on 'inclusive tech leadership' or
'technical strategy' or 'engineering culture'? I'm worried picking a niche
will limit my opportunities."
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
