---
name: passive-income-reality-check
version: 1.0.0
---

# Initialization

A reality-based passive income evaluation skill that helps users assess income opportunities against their actual constraints—capital, time, skills, and risk tolerance—filtering hype from viable strategies.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive evaluation frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r passive-income-reality-check/ ~/.claude/skills/passive-income-reality-check/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{available_capital}}` | `$1,000` | Starting investment amount you can afford to lose |
| `{{time_per_week}}` | `10 hours` | Hours per week you can dedicate upfront |
| `{{target_monthly_income}}` | `$500` | Desired monthly passive income goal |
| `{{time_horizon_months}}` | `12 months` | How long until you need meaningful income |
| `{{skill_level}}` | `beginner` | Your current proficiency level |
| `{{risk_tolerance}}` | `moderate` | Comfort level with volatility and potential loss |

## Core Capabilities

1. **Viability Screening** - Evaluate any passive income strategy against your specific constraints
2. **Capital-to-Income Mapping** - Calculate realistic income potential based on available capital
3. **Time-to-First-Dollar Forecasting** - Estimate actual timelines for different strategies
4. **Myth Debunking** - Distinguish genuine passive income from scams and semi-passive work
5. **Strategy Matching** - Recommend 3-5 strategies ranked by fit to your situation
6. **90-Day Action Planning** - Provide realistic roadmaps with checkpoints
7. **Red Flag Detection** - Identify pyramid schemes, oversaturated markets, and unrealistic claims

## Key Frameworks

### The Passive Income Ladder
- **Stage 1 (Sweat Equity)**: $0-500 capital, 15-20 hrs/week, 60-180 days to income
- **Stage 2 (Modest Capital)**: $500-5k capital, 5-10 hrs/week, 30-120 days to income
- **Stage 3 (Significant Capital)**: $5-50k capital, 2-5 hrs/week, 1-6 months to income
- **Stage 4 (Major Capital)**: $50k-250k+ capital, 1-2 hrs/week, days to weeks to income

### The 60-30-10 Capital Split
- 60% primary strategy (highest conviction)
- 30% secondary income stream (diversification)
- 10% experimentation fund (learning)

### The Flywheel Effect
- Months 1-3: Setup phase (most quit here)
- Months 4-6: First traction (30-50% of target)
- Months 7-12: Compounding begins (80-120% of target)
- Year 2: Acceleration (2-5x Year 1)

## Example Usage

```
"I have $3,000 saved up and can dedicate 8 hours per week for the next 6 months.
I want to make $500/month in passive income. I'm thinking of starting a YouTube
channel teaching Excel skills—I have 10 years of experience. Is this realistic?
What's my actual time-to-first-dollar, and what are my alternatives?"
```

## Research Sources

- Passive Income Reality Check: 7 Proven Truths (2025) - simplecoffers.com
- Capital Requirements for Passive Income - vocal.media
- Bankrate: 25 Passive Income Ideas 2025 - bankrate.com
- Is Passive Income Real? Myths vs. Reality - barbarafriedbergpersonalfinance.com
- 10 Myths About Passive Income - connecteninternet.com
- How Long Does It Take to Build Passive Income? - schoolsofspanish.com
- 19 Passive Income Ideas to Start in 2025 - networksolutions.com
- 20 Best Passive Income Ideas 2025 - llcattorney.com

---
Downloaded from [Find Skill.ai](https://findskill.ai)
