---
name: okr-kpi-goal-setter
version: 1.0.0
---

# OKR/KPI Goal-Setter - Initialization

Transform annual strategy into quarterly OKRs with cascading alignment, measurable key results, and weekly check-in protocols for organizational focus.

## What This Skill Does

This skill provides a comprehensive framework for implementing Objectives and Key Results (OKRs) in any organization. It helps you:

- Translate ambitious annual strategies into measurable quarterly objectives
- Cascade or align OKRs across company, team, and individual levels
- Create truly measurable key results (not task lists)
- Establish weekly check-in and end-of-quarter scoring protocols
- Avoid common OKR implementation pitfalls (based on Google, Intel patterns)
- Troubleshoot OKR execution issues

## Structure

```
okr-kpi-goal-setter/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This file (initialization instructions)
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### For Claude Code

```bash
# Copy the skill to your Claude skills directory
cp -r okr-kpi-goal-setter/ ~/.claude/skills/okr-kpi-goal-setter/
```

After installation, invoke with:
```
Use skill okr-kpi-goal-setter
```

### For ChatGPT/GPT-4

1. Open `SKILL.md`
2. Copy everything after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or custom instructions
4. Begin your OKR planning session

### For Claude.ai (Web)

1. Open `SKILL.md`
2. Copy the entire content after frontmatter
3. Start a new conversation and paste
4. Or create a Project and add as project knowledge

### For Gemini

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste at the start of your conversation
4. Reference the OKR framework in subsequent prompts

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{okr_cycle_duration}}` | `quarterly` | OKR timeframe: quarterly, semi-annual, or annual |
| `{{cascade_model}}` | `hybrid` | Distribution: cascading, alignment, or hybrid |
| `{{key_results_per_objective}}` | `3` | Number of KRs per objective (2-5) |
| `{{objectives_per_level}}` | `3` | Number of objectives per level (2-5) |
| `{{target_achievement_rate}}` | `0.65` | Expected achievement (0.6-0.7 for stretch) |
| `{{check_in_frequency}}` | `weekly` | Review cadence: weekly, bi-weekly, monthly |
| `{{separate_from_compensation}}` | `true` | Keep OKRs separate from pay decisions |

## Quick Start Examples

### Example 1: Annual-to-Quarterly Breakdown
```
"Our company's annual priority is to double ARR to $10M. We're at $5M.
Help me create Q1 2025 OKRs for company, product, sales, and marketing teams.
We're B2B SaaS with 3-month sales cycles."
```

### Example 2: Review Existing OKRs
```
"Here are my team's OKRs for this quarter:
Objective: Improve customer satisfaction
KR1: Conduct 20 customer surveys
KR2: Improve NPS
KR3: Reduce churn

Please review these and identify any issues."
```

### Example 3: Troubleshoot OKR Problems
```
"My teams consistently hit 100% of their OKRs but we're not seeing
business results. What's wrong and how do we fix it?"
```

### Example 4: Score End-of-Quarter OKRs
```
"Help me score these OKRs:
Objective: Launch enterprise product
KR1: Acquire 10 enterprise customers (achieved 7)
KR2: Reach $2M ARR from enterprise (achieved $1.8M)
KR3: Hire 5-person sales team (hired 4)"
```

## Key Concepts Quick Reference

```
OBJECTIVE = WHAT (qualitative, inspirational)
KEY RESULT = HOW TO MEASURE (quantitative, specific)

Limits: 3-5 objectives, 3-5 KRs each
Target: 60-70% achievement (stretch goals)
Cadence: Weekly check-ins, quarterly scoring

Golden Rules:
1. Outcomes over outputs
2. Less is more (focus!)
3. Separate from compensation
4. Transparency always
5. Enable course correction
```

## Related Skills

- **KPI & Metrics Designer** - Design individual metrics that feed into OKR key results
- **Goal Framework Strategist** - Complementary goal-setting frameworks
- **Performance Review Generator** - Use OKR achievements in reviews
- **Business Model Canvas Generator** - Strategic context for OKRs
- **Dashboard Designer** - Visualize OKR progress

## Troubleshooting

**Issue: AI treats OKRs as task lists**
- Remind: "Focus on outcomes, not outputs. KRs measure results, not activities."

**Issue: Key results aren't measurable**
- Prompt: "Every KR needs a number and a unit. Baseline to target format."

**Issue: Too many objectives generated**
- Constrain: "Maximum 3-5 objectives. Force prioritization."

**Issue: Not addressing team context**
- Provide: Organization size, industry, current OKR maturity level

---
Downloaded from [Find Skill.ai](https://findskill.ai)
