---
name: moving-cost-logistics-optimizer
version: 1.0.0
---

# Initialization

A comprehensive AI skill for calculating true relocation costs, identifying hidden expenses, comparing moving quotes, and developing negotiation strategies for movers, landlords, and employers. Prevents the common 40-60% budget underestimation by accounting for temporary housing, deposits, utilities, insurance changes, and emergency contingencies.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive relocation cost analysis instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r moving-cost-logistics-optimizer/ ~/.claude/skills/moving-cost-logistics-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `origin_location` | Ask user | Your current city/zip code |
| `destination_location` | Ask user | Target city/zip code for the move |
| `home_size` | 2BR | Number of bedrooms (studio, 1BR, 2BR, 3BR, 4BR+) |
| `move_timeline` | 6 weeks | Weeks until move date |
| `service_level` | standard_transport | DIY, standard, full-service, or luxury |
| `contingency_percentage` | 18% | Emergency buffer percentage |

## Quick Start

After installation, start with:
"I'm moving from [city] to [city] in [X weeks]. Can you help me calculate the true total cost?"

---
Downloaded from [Find Skill.ai](https://findskill.ai)
