---
name: mortgage-qualification-roadmap
version: 1.0.0
---

# Initialization

A comprehensive mortgage qualification advisor that helps prospective homebuyers understand lending requirements, assess their current readiness, and create personalized roadmaps to achieve mortgage approval across conventional, FHA, VA, and USDA loan programs.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete mortgage qualification guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r mortgage-qualification-roadmap/ ~/.claude/skills/mortgage-qualification-roadmap/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert mortgage qualification advisor...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

This skill provides:

1. **Qualification Assessment** - Analyzes user's financial profile against conventional, FHA, VA, and USDA loan requirements
2. **Credit Score Impact Analysis** - Explains how credit scores affect approval, rates, and down payments with improvement strategies
3. **DTI Ratio Optimization** - Calculates debt-to-income ratios and provides reduction strategies
4. **Down Payment Strategy** - Maps down payment options from 0% to 20%+ with cost-benefit analysis
5. **Documentation Preparation** - Comprehensive checklists for W-2 employees and self-employed borrowers
6. **Timeline Management** - Creates realistic timelines from pre-qualification through closing
7. **Loan Type Recommendations** - Personalized loan type recommendations based on borrower profile

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_loan_type}}` | `conventional` | Mortgage type: conventional, fha, va, or usda |
| `{{debt_to_income_limit}}` | `0.43` | Maximum DTI ratio as decimal (0.43 = 43%) |
| `{{minimum_credit_score}}` | `620` | Lender minimum credit score requirement |
| `{{down_payment_percent}}` | `0.10` | Down payment as decimal (0.10 = 10%) |
| `{{timeline_months}}` | `6` | Months available to prepare for mortgage qualification |
| `{{employment_type}}` | `w2` | Borrower employment: w2, self_employed, or contract |

## Example Usage

```
User: I'm a first-time homebuyer in Atlanta making $65,000/year. My credit score
is 595, I have $15,000 in student loans and $3,000 in credit card debt, and I've
saved $12,000 for a down payment. I want to buy a $250,000 home within 8 months.
Which loan type works best for me, and what should I prioritize?

AI: [Calculates DTI, recommends FHA loan, creates 8-month improvement roadmap
focusing on credit score improvement and down payment savings]
```

## Research Sources

This skill was developed using research from:
- LendingTree Minimum Mortgage Requirements 2025
- Bankrate Down Payment & DTI Guides
- Fannie Mae Credit Score Requirements
- Freddie Mac Self-Employed Mortgage Guide
- Rocket Mortgage Underwriting Timeline
- Bank of America Pre-Qualification Guide
- Experian Credit Preparation Guide
- CrossCountry Conventional Loan Requirements
- PNC Debt-to-Income Ratio Guidance

---
Downloaded from [Find Skill.ai](https://findskill.ai)
