---
name: monetization-model-mapper
version: 1.0.0
---

# Initialization

Strategic AI tool that helps content creators and digital publishers systematically evaluate and select optimal revenue streams based on audience profile, content niche, and business goals. Provides data-driven recommendations backed by 2025 industry benchmarks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive monetization strategy instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r monetization-model-mapper/ ~/.claude/skills/monetization-model-mapper/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audience_size}}` | `50000` | Total follower count across all platforms |
| `{{engagement_rate}}` | `5.0` | Average engagement percentage (likes, comments, shares) |
| `{{niche_category}}` | `lifestyle` | Primary content niche (finance, tech, lifestyle, health, education, B2B) |
| `{{primary_platform}}` | `youtube` | Main distribution platform (youtube, tiktok, instagram, newsletter, podcast) |
| `{{income_goal_monthly}}` | `5000` | Target monthly income in USD |
| `{{available_hours_weekly}}` | `10` | Hours per week available for monetization activities |

## Key Capabilities

1. **Revenue Stream Auditor** - Evaluates 10+ revenue models with personalized scoring
2. **Audience Segmentation Analyzer** - Identifies monetizable audience segments
3. **Diversification Strategist** - Recommends balanced revenue portfolio
4. **Platform Fit Analyzer** - Maps content to platform-native monetization tools
5. **Competitive Benchmarker** - Provides industry-standard rates and expectations
6. **Implementation Roadmap Generator** - Creates phased 3-6 month activation plans
7. **ROI Optimizer** - Tracks and optimizes underperforming streams

## Example Usage

```
I'm a fitness creator with 85K Instagram followers and 12K YouTube subscribers.
My engagement rate is about 4.2%. I currently make around $800/month from
occasional sponsorships but want to hit $4,000/month within 6 months. I can
dedicate about 8 hours per week to monetization beyond content creation. My
audience is mostly women 25-40 with disposable income. What revenue streams
should I prioritize and in what order?
```

## Research Sources

This skill was developed using comprehensive 2025 creator economy research including:
- VdoCipher Content Monetization Guide
- Automateed Creator Business Models
- Shopify Creator Economy Analysis
- Stripe Creator Monetization Platforms
- Academic research on digital content monetization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
