---
name: market-positioning-analyzer
version: 1.0.0
---

# Initialization

Market Positioning Analyzer helps you develop strategic market positioning using Porter's frameworks, perceptual mapping, and competitive analysis to differentiate your brand and capture market share.

## Structure

- `SKILL.md` - Main skill prompt (comprehensive positioning analysis system)

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r market-positioning-analyzer/ ~/.claude/skills/market-positioning-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Market Positioning Analyzer")
3. Paste into AI assistant as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_market_segment}}` | `General/Broad` | The specific customer segment or market you're targeting |
| `{{primary_differentiator}}` | `Quality` | Main factor that distinguishes your offering |
| `{{competitive_strategy_type}}` | `Differentiation` | Porter's generic strategy choice |
| `{{positioning_time_horizon}}` | `12 months` | Expected timeframe for establishing positioning |
| `{{competitive_intensity_level}}` | `High` | Market competition assessment |
| `{{positioning_update_frequency}}` | `Quarterly` | How often to reassess positioning |

## Quick Start Examples

### B2B SaaS Repositioning
```
Help me develop a competitive positioning analysis for our project management
software. Our current positioning emphasizes 'most features' but customers
are increasingly choosing simpler tools.

Analyze the top 5 competitors across dimensions that matter most to SMB
customers, create a perceptual map, identify white space positioning
opportunities, and develop a positioning statement.
```

### Consumer Brand Market Entry
```
I'm launching a direct-to-consumer sustainable fashion brand targeting
millennial professionals. Help me establish market positioning by analyzing
competitor positions, creating a perceptual map using price and sustainability
axes, developing a unique value proposition, and creating a positioning statement.
```

### Competitive Intelligence Analysis
```
Conduct market positioning analysis for fitness equipment using customer
intelligence. Identify how customers perceive major competitors, extract
unmet customer needs, create a competitive positioning summary, and
recommend positioning for a new market entrant targeting budget-conscious
fitness enthusiasts.
```

## Core Capabilities

This skill enables you to:

1. **Competitive Analysis Framework** - Map competitors across dimensions, build competitive profile matrices, conduct SWOT analysis
2. **Value Proposition Development** - Create USPs and value propositions using canvas approach
3. **Market Segmentation** - Define target segments using B2B/B2C criteria, build buyer personas
4. **Positioning Statement Creation** - Develop clear statements using proven templates
5. **Perceptual Mapping** - Visualize competitive landscape and identify white space
6. **Porter's Generic Strategies** - Apply cost leadership, differentiation, and focus strategies
7. **Brand Monitoring** - Track positioning effectiveness and competitive moves

## Key Frameworks Included

- Porter's Three Generic Strategies
- STP Model (Segmentation, Targeting, Positioning)
- Value Proposition Canvas
- Competitive Profile Matrix
- SWOT Analysis Framework
- Porter's Five Forces
- Perceptual Mapping Techniques

---
Downloaded from [Find Skill.ai](https://findskill.ai)
