---
name: market-expansion-feasibility
version: 1.0.0
---

# Initialization

Market Expansion Feasibility Analyst - A comprehensive AI skill for evaluating market expansion viability across geographic, product, and segment dimensions with structured analysis frameworks including TAM/SAM/SOM, Porter's Five Forces, SWOT, Ansoff Matrix, financial projections, and risk assessment.

## Structure

- `SKILL.md` - Main skill prompt with complete analysis framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r market-expansion-feasibility/ ~/.claude/skills/market-expansion-feasibility/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{market_type}}` | `geographic` | Type of expansion: geographic, product, segment, or combined |
| `{{time_horizon_years}}` | `3` | Planning period for financial projections (1-10 years) |
| `{{risk_tolerance_level}}` | `moderate` | Risk tolerance: conservative, moderate, or aggressive |
| `{{primary_research_depth}}` | `basic` | Research scope: desktop_only, basic, or comprehensive |
| `{{analysis_scope}}` | `standard` | Analysis depth: quick_assessment, standard, or detailed |
| `{{competitive_focus}}` | `direct_and_indirect` | Competitive scope: direct_only, direct_and_indirect, or ecosystem |

## Analysis Frameworks Included

### Market Sizing (TAM/SAM/SOM)
- **TAM (Total Addressable Market)**: Entire potential market demand
- **SAM (Serviceable Available Market)**: Portion you can realistically target
- **SOM (Serviceable Obtainable Market)**: Realistic market share capture

### Porter's Five Forces
- Competitive rivalry intensity
- Supplier bargaining power
- Buyer bargaining power
- Threat of substitutes
- Threat of new entrants

### Ansoff Growth Matrix
- Market Penetration (existing product, existing market)
- Market Development (existing product, new market)
- Product Development (new product, existing market)
- Diversification (new product, new market)

### Financial Analysis
- Revenue projections (3 scenarios)
- Cost structure analysis
- Unit economics (LTV, CAC, payback)
- Break-even analysis
- NPV/IRR calculations

### Risk Assessment
- Market demand risks
- Competitive risks
- Operational risks
- Financial risks
- Regulatory risks
- Cultural/localization risks

## Workflow Options

### Quick Assessment (45-60 min)
- 5-15 page analysis summary
- TAM/SAM/SOM estimates
- Top 5 competitors overview
- Key risk summary
- Go/no-go recommendation

### Standard Analysis (2-3 hours)
- 20-30 page strategic analysis
- Detailed market sizing with scenarios
- Full competitive landscape
- Complete SWOT analysis
- Financial projections (3-5 year)
- Comprehensive risk register
- Phased implementation roadmap

### Detailed Study (4-8+ hours)
- 40-60 page comprehensive feasibility study
- Primary and secondary research synthesis
- Detailed financial models with sensitivity
- Complete Porter's Five Forces analysis
- Regulatory deep-dive
- Organizational readiness assessment
- Full implementation plan

## Example Usage

```
I'm evaluating whether my US-based SaaS HR platform should expand
into Canada, UK, or Australia. We have limited resources and need
to prioritize one market for 2025. Please conduct a market feasibility
assessment analyzing TAM/SAM/SOM for each region, competitive landscape
with 5+ competitors per market, regulatory compliance requirements,
localization needs, and provide a prioritized recommendation with
top 10 expansion risks and mitigation strategies. Focus on the SMB
segment (10-500 employees) that we currently serve successfully.
```

## Research Sources

1. Metheus Consultancy - Market Feasibility Analysis Framework
2. Nexdigm - 360-Degree Market Assessment Methodology
3. Shopify - Market Entry Strategy Guide
4. Porter's Five Forces - Industry Attractiveness Analysis
5. TAM/SAM/SOM - Market Sizing Methodology
6. M Accelerator - Market Entry Risk Assessment Framework
7. Ansoff Matrix - Growth Strategy Framework
8. Business Model Canvas - Strategic Framework
9. STP Marketing Strategy - Segmentation Methodology
10. Hanover Research - Market Entry Steps

---
Downloaded from [Find Skill.ai](https://findskill.ai)
