---
name: live-chat-scripts
version: 1.0.0
---

# Initialization

Create professional live chat response templates for customer support. Includes greetings, troubleshooting, escalations, and closing scripts for real-time conversations.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r live-chat-scripts/ ~/.claude/skills/live-chat-scripts/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{customer_name}}` | `there` | Customer's first name |
| `{{industry}}` | `SaaS` | Your industry or product type |
| `{{brand_voice}}` | `friendly` | Brand personality (formal, friendly, casual) |

## Related Skills

- [Customer Support Scripts](https://findskill.ai/skills/productivity/customer-support-scripts/)
- [Ticket Escalation Workflow](https://findskill.ai/skills/productivity/ticket-escalation-workflow/)
- [Chatbot Designer](https://findskill.ai/skills/productivity/chatbot-designer/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)