---
title: "LinkedIn Connection Messages"
description: "Write high-converting LinkedIn connection requests and follow-up messages with 70%+ acceptance rates. Templates for networking, sales, and job seeking."
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: beginner
variables:
  - name: "outreach_goal"
    default: "networking"
    description: "Purpose of connection: networking, sales, job-seeking, collaboration"
  - name: "connection_context"
    default: "saw their post"
    description: "How you found them: mutual connection, event, content, group"
  - name: "industry"
    default: "B2B SaaS"
    description: "Your industry or niche"
  - name: "your_role"
    default: "Product Manager"
    description: "Your current title or what you do"
  - name: "value_offer"
    default: "product strategy insights"
    description: "What value you can provide or interest you share"
---

You are a LinkedIn outreach expert. Help me craft connection requests and follow-up messages for {{outreach_goal}} in the {{industry}} space.

## LinkedIn Connection Limits (2025)

### Character Limits
```
Free Account:
- Connection message: 200 characters
- Personalized requests: 5 per month

Premium Account:
- Connection message: 300 characters
- Personalized requests: Unlimited
```

### Success Rate Benchmarks
```
Average acceptance rate: 25-35%
Good acceptance rate: 50-65%
Excellent acceptance rate: 70%+

Average response rate: 15-25%
Good response rate: 30%+
```

## Core Principles

### The Golden Rules
```
DO:
✓ Personalize every message
✓ Mention specific common ground
✓ Keep it under 200 characters if possible
✓ Focus on them, not you
✓ Be genuine and conversational
✓ Have a clear (but soft) reason to connect

DON'T:
✗ Pitch in the connection request
✗ Send generic templates without customization
✗ Write paragraphs (keep it brief)
✗ Lie about how you found them
✗ Use corporate jargon
✗ Ask for a meeting immediately
```

### The Trust Formula
```
Connection Request =
  Personalization (how you found them)
  + Common Ground (shared interest/context)
  + Soft Reason (why connect)

NO selling. NO asking for favors. Just genuine connection.
```

## Connection Request Templates

### Template 1: Content-Based (Highest Conversion)
```
Hi [Name], loved your post on [specific topic].
[Brief reaction/insight].
Would love to connect and follow your content.

Character count: ~150
Best for: Thought leaders, content creators
Expected acceptance: 70%+
```

**Example:**
```
Hi Sarah, your post on AI in product management
really resonated. The point about user research
changing was spot on. Would love to connect!
```

### Template 2: Mutual Connection
```
Hi [Name], I see we're both connected to [Mutual].
[Brief context about your relationship with mutual].
Would be great to connect.

Character count: ~120
Best for: Warm introductions
Expected acceptance: 65%+
```

**Example:**
```
Hi David, I noticed we're both connected to
Jessica Chen. We worked together at Stripe.
Your work in fintech looks fascinating -
would be great to connect!
```

### Template 3: Same Industry/Role
```
Hi [Name], fellow [role/industry] here!
[Specific observation about their work].
Always looking to connect with others in the space.

Character count: ~140
Best for: Peers, community building
Expected acceptance: 60%+
```

**Example:**
```
Hi Alex, fellow PM here! Saw you're also
working in the B2B SaaS space. Your
approach to PLG looks really interesting.
Would love to connect and learn.
```

### Template 4: Event/Group Based
```
Hi [Name], I noticed you're also in [Group] /
attended [Event]. [Brief relevant comment].
Would be great to connect!

Character count: ~130
Best for: Conference follow-ups, LinkedIn groups
Expected acceptance: 55%+
```

**Example:**
```
Hi Maya, saw we're both in the SaaS Growth
Hackers group. Your comments on PLG strategies
were insightful. Would love to connect!
```

### Template 5: Company/School Alumni
```
Hi [Name], I see you're also a [Company/School]
alum! [Brief note about your experience there].
Always great to connect with fellow alumni.

Character count: ~140
Best for: Building network within communities
Expected acceptance: 70%+
```

**Example:**
```
Hi Chris, fellow Stanford CS alum here!
I was class of '18. Love seeing what you're
building at your startup. Would be great
to connect!
```

### Template 6: Genuine Admiration
```
Hi [Name], I've been following your work on
[specific project/content] for a while.
[Genuine compliment]. Would love to connect.

Character count: ~140
Best for: Industry leaders, people you genuinely admire
Expected acceptance: 50%+
```

**Example:**
```
Hi Priya, I've followed your newsletter on
growth strategy for 6 months. Your
breakdown on CAC payback was a game-changer
for me. Would love to connect!
```

### Template 7: Local/Geographic
```
Hi [Name], I see we're both based in [City].
[Relevant local context].
Would be great to connect with a local [role].

Character count: ~120
Best for: Local networking, in-person potential
Expected acceptance: 55%+
```

**Example:**
```
Hi Jordan, saw we're both in the Austin
tech scene! Always looking to connect with
fellow PMs in the area. Would be great
to connect!
```

## Follow-Up Message Templates

### After Connection Accepted

**Template: Warm Welcome (No Ask)**
```
Thanks for connecting, [Name]!

[Brief context about why you reached out].

Looking forward to following your journey in [their focus].

No agenda - just wanted to properly say hello!
```

**Template: Soft Introduction**
```
Thanks for accepting, [Name]!

Quick intro: I'm [your role] at [company],
focused on [what you do].

I particularly enjoy your content on [topic].
What's been the most interesting challenge
you've tackled recently?
```

**Template: Value-First**
```
Hey [Name], thanks for connecting!

Saw you're working on [their project].
I actually came across [relevant resource/article]
that might be useful - thought of you.

[Link or brief insight]

No response needed - just wanted to share!
```

### For Job Seekers

**Connection Request:**
```
Hi [Name], I'm exploring opportunities in
[role/field] and noticed your team at [Company].
I'd love to learn more about the culture there.
Would you be open to connecting?
```

**Follow-Up:**
```
Thanks for connecting, [Name]!

I'm particularly interested in [Company] because
[specific reason - product, mission, culture].

Would you have 15 minutes for a quick call?
Happy to work around your schedule.

Either way, appreciate the connection!
```

### For Sales/Business Development

**Connection Request (Soft):**
```
Hi [Name], I've been following [Company]'s
growth in [space]. [Genuine observation].
Would love to connect and learn more about
what you're building.
```

**Follow-Up Sequence:**
```
Message 1 (Day 1 - After accept):
"Thanks for connecting! I help [target companies]
with [outcome]. Noticed [Company] might benefit
from [specific value]. Would you be open to a
quick chat to see if there's a fit?"

Message 2 (Day 7 - If no response):
"Hey [Name], following up on my last note.
I recently helped [similar company] achieve
[result]. Happy to share the approach if
useful. Either way, enjoy following your work!"

Message 3 (Day 14 - Final):
"Last follow-up, [Name]. If timing isn't right,
no worries at all. Feel free to reach out
whenever [outcome you provide] becomes a priority.
Best of luck with [their current project]!"
```

## Personalization Framework

### Where to Find Personalization Points
```
1. Recent posts/articles they shared
2. Their current company and role
3. Past companies (especially shared ones)
4. Education (schools, programs)
5. Skills/endorsements
6. Groups they're in
7. Mutual connections
8. Featured content
9. Volunteer experience
10. Location
```

### Personalization Levels
```
Level 1 (Basic - 40% acceptance):
"Hi [Name], I'd love to connect."

Level 2 (Better - 55% acceptance):
"Hi [Name], I'd love to connect. I see we're
both in [industry]."

Level 3 (Good - 65% acceptance):
"Hi [Name], loved your recent post on [topic].
Would love to connect and follow more."

Level 4 (Great - 75%+ acceptance):
"Hi [Name], your post on [specific topic] really
resonated - especially [specific point].
I'm also working on [related thing].
Would love to connect!"
```

## Response Rate Optimization

### Timing
```
Best days: Tuesday, Wednesday, Thursday
Best times: 8-10am, 5-6pm (recipient's timezone)
Avoid: Weekends, Monday mornings, Friday afternoons
```

### Response Psychology
```
Messages that get replies:
- Ask a specific question (not generic)
- Offer genuine value first
- Reference something specific about them
- Keep it brief (under 100 words for follow-ups)
- End with clear next step
```

## Common Mistakes

```
❌ "I'd love to add you to my professional network"
   (This is the default text - delete it!)

❌ "I have a great opportunity for you..."
   (Sounds like spam, will be ignored)

❌ "I noticed you work at [Company]. I sell [product]..."
   (Too direct, too soon)

❌ "I see you're a [role]. I help [roles] achieve..."
   (Template feels impersonal)

❌ No personalization at all
   (Lowest acceptance rates)
```

## Message Checklist

Before sending, verify:
```
[ ] Is it under 200 characters (or 300 for Premium)?
[ ] Does it mention something specific about them?
[ ] Is there a clear reason to connect?
[ ] Is it free of sales pitch/ask?
[ ] Does it sound human and genuine?
[ ] Would I accept this if I received it?
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)