---
name: learning-path-designer
version: 1.0.0
---

# Initialization

Learning Path Designer helps L&D professionals, educators, trainers, and organizations design personalized, effective learning paths and curricula using proven instructional design methodologies including ADDIE, Bloom's Taxonomy, and competency mapping.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete instructional design guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r learning-path-designer/ ~/.claude/skills/learning-path-designer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are an expert instructional designer...")
3. Paste into your AI assistant's system prompt or custom instructions
4. Begin designing learning paths immediately

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Use Cases

This skill supports:

1. **Personalized Learning Path Generation** - Create customized, sequenced learning journeys based on learner profiles (current skills, goals, learning style, available time)

2. **Curriculum Design & Restructuring** - Design entire programs using ADDIE framework, map learning objectives to Bloom's taxonomy, create prerequisite chains

3. **Knowledge Gap Identification** - Diagnose why learners struggle, identify missing prerequisite knowledge, design targeted remediation

4. **Competency Framework Development** - Build skill taxonomies with proficiency levels, map prerequisites and dependencies, validate against industry standards

5. **Assessment Design** - Create formative and summative assessments aligned to learning objectives and Bloom's levels

6. **Adaptive Difficulty Calibration** - Design learning experiences that adjust to learner performance using ZPD principles

7. **Content Curation & Sequencing** - Select and sequence resources optimally based on learning science principles

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{learner_profile_complexity}}` | `intermediate` | Learner's current proficiency level (beginner/intermediate/advanced) |
| `{{time_availability_hours_per_week}}` | `5` | Hours per week learner can dedicate to learning |
| `{{learning_modality_preferences}}` | `video, interactive, practice` | Preferred content formats |
| `{{assessment_frequency}}` | `weekly` | How often to include formative assessments |
| `{{prerequisite_strictness}}` | `moderate` | How strictly to enforce prerequisites (loose/moderate/strict) |
| `{{bloom_taxonomy_focus}}` | `understand, apply, analyze` | Cognitive levels to emphasize |

## Example Prompts

**Create a learning path:**
```
I need to design a 12-week learning path for a business analyst transitioning to a data analyst role. They have 3 years of Excel and SQL basics experience but are weak in statistics and Python. They can dedicate 8 hours per week, prefer video and hands-on labs, and need to use only free tools.
```

**Redesign a curriculum:**
```
Our software engineering bootcamp needs to add DevOps/cloud skills while keeping the 12-week format. Current modules are Fundamentals, Frontend, Backend, Projects. Employers want more containerization and CI/CD. Help me redesign the curriculum.
```

**Gap analysis:**
```
A learner passed modules 1-2 of our Statistics for Data Science course (75%+) but failed module 3 on Hypothesis Testing (62%). They say they feel lost on p-values and don't understand when to reject the null hypothesis. Help me diagnose and remediate.
```

## Key Frameworks Included

- **ADDIE Model**: Analyze → Design → Develop → Implement → Evaluate
- **Bloom's Taxonomy**: Remember → Understand → Apply → Analyze → Evaluate → Create
- **Kirkpatrick's Four Levels**: Reaction → Learning → Behavior → Results
- **Backward Design**: Outcomes → Evidence → Learning Experiences
- **Zone of Proximal Development**: Calibrate difficulty to learner readiness
- **Adult Learning Principles (Andragogy)**: Self-direction, relevance, experience-based

## Output Formats

The skill produces structured outputs including:
- Learning path documents with week-by-week schedules
- Competency frameworks with proficiency levels
- Gap analysis reports with remediation plans
- Assessment alignment matrices
- Prerequisite dependency maps

---
Downloaded from [Find Skill.ai](https://findskill.ai)
