---
name: job-offer-comparison-tool
version: 1.0.0
---

# Initialization

A systematic Job Offer Comparison Tool that helps professionals evaluate multiple job offers using weighted scoring methodology, total compensation analysis, and cost-of-living adjustments for data-driven career decisions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for comparing job offers

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r job-offer-comparison-tool/ ~/.claude/skills/job-offer-comparison-tool/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{salary_weight}}` | `0.30` | Importance weight for compensation factor (0-1) |
| `{{culture_weight}}` | `0.15` | Importance weight for company culture fit (0-1) |
| `{{growth_weight}}` | `0.25` | Importance weight for career advancement (0-1) |
| `{{work_life_balance_weight}}` | `0.20` | Importance weight for work-life balance (0-1) |
| `{{location_weight}}` | `0.10` | Importance weight for geography (0-1) |
| `{{bonus_confidence}}` | `0.75` | Expected likelihood of earning advertised bonus (0-1) |

## Core Capabilities

1. **Total Compensation Analysis** - Calculate base salary, bonuses, equity, and benefits across offers
2. **Weighted Scoring System** - Apply user-defined importance weights to compare objectively
3. **Cost-of-Living Adjustment** - Normalize salaries for geographic differences
4. **5-Year Financial Projection** - Model long-term wealth impact
5. **Benefits Package Valuation** - Monetize non-cash compensation
6. **Career Growth Assessment** - Evaluate advancement potential
7. **Decision Matrix Export** - Generate visual comparison reports

## Example Usage

```
User: "I have two software engineer offers. Offer A: Big Tech company - $180K base,
$45K bonus, $320K in RSUs vesting over 4 years, SF location. Offer B: Series B
startup - $160K base, $20K bonus, $200K in equity, Austin location. I'm early-career
(5 years experience) and growth-focused. Which offer is better?"
```

## Research Sources

- Free Job Offer Comparison Calculator (careeragents.org)
- Job Offer Calculator - Ideal Salary and Benefits (calculator.cool)
- What to Consider When Evaluating a Job Offer (USC Careers)
- How to Compare Competing Job Offers (LinkedIn)
- How to Compare Total Compensation Packages (Monster)
- Weighted Scoring Model Guide (Userpilot)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
