---
name: insurance-coverage-optimizer
version: 1.0.0
---

# Initialization

Insurance Coverage Optimizer is an AI skill that analyzes complete insurance portfolios to identify coverage gaps, eliminate redundancies, optimize premiums, and ensure adequate protection across health, auto, home, life, disability, and umbrella policies.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive workflows for portfolio analysis, life-event adjustments, disability needs analysis, premium optimization, and umbrella liability assessment

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r insurance-coverage-optimizer/ ~/.claude/skills/insurance-coverage-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as system prompt or conversation starter

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Coverage Gap Analysis** - Identify underinsured areas by comparing assets, liabilities, and income against current policy limits
2. **Redundancy Detection** - Flag overlapping coverage across policies and calculate savings from elimination
3. **Life-Event Assessment** - Recommend coverage adjustments after major changes (marriage, birth, property purchase, job loss)
4. **Premium Optimization** - Analyze deductibles, bundling opportunities, and policy alternatives to reduce costs
5. **Portfolio Coordination** - Ensure policies work together seamlessly (e.g., auto liability limits align with umbrella coverage)
6. **Umbrella Liability Assessment** - Calculate appropriate excess liability protection based on net worth and exposure factors

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{household_monthly_income}}` | `5000` | Combined gross monthly household income |
| `{{household_monthly_expenses}}` | `3500` | Total monthly living expenses |
| `{{dependents_count}}` | `0` | Number of financial dependents |
| `{{home_market_value}}` | `450000` | Current home market value |
| `{{emergency_fund_months}}` | `3` | Months of expenses in liquid savings |
| `{{coverage_gap_tolerance_percent}}` | `15` | Maximum acceptable unprotected percentage |

## Example Usage

```
Analyze my family's insurance portfolio for gaps and redundancies.
Combined income $95K, home value $425K, two vehicles worth $40K total,
$8,500 emergency fund. Current coverage: State Farm auto ($100K/$300K/$100K),
Geico auto ($50K/$100K/$50K), State Farm homeowners ($350K dwelling),
$250K term life on spouse A only, employer disability (60% income).
We're planning for children in 2-3 years. What gaps should we address
and where can we save money?
```

## Key Analysis Outputs

The skill generates structured reports including:
- Insurance Portfolio Analysis Report (comprehensive review)
- Critical Gaps Identified (prioritized by risk)
- Redundancies Detected (with savings opportunities)
- Optimization Opportunities (bundling, deductibles, discounts)
- Implementation Plan (immediate, short-term, at renewal)
- Disability Insurance Recommendation (with policy specifications)
- Umbrella Liability Recommendation (with underlying policy requirements)

## Industry Standards Referenced

| Risk Category | Minimum Standard | High Net Worth |
|---------------|------------------|----------------|
| Auto Liability | $100K/$300K/$100K | $250K/$500K/$250K+ |
| Homeowners Liability | $300K | $500K+ |
| Umbrella | 1× Net Worth | 2-3× Net Worth |
| Life Insurance | 8-10× Annual Income | Plus education + debt |
| Disability | 60% Income | Supplement group coverage |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
