---
name: instant-prompt-optimizer
version: 1.0.0
---

# Initialization

**Instant Prompt Optimizer** transforms vague, rough prompts into polished, effective versions in seconds. Paste your prompt → get an optimized version + explanation of improvements.

This skill is perfect for:
- Casual AI users frustrated with generic outputs
- Content creators (bloggers, marketers, copywriters)
- Professionals (consultants, managers, knowledge workers)
- Anyone who wants better AI results without learning prompt engineering

## Structure

```
instant-prompt-optimizer/
├── SKILL.md          # Main skill prompt (copy this to use)
└── INIT.md           # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r instant-prompt-optimizer/ ~/.claude/skills/instant-prompt-optimizer/

# Or add to your project's skills
cp -r instant-prompt-optimizer/ .claude/skills/instant-prompt-optimizer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's chat or custom instructions

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the SKILL.md content as system instructions
3. Name it "Instant Prompt Optimizer"
4. Set description: "Transform vague prompts into effective ones instantly"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{rough_prompt}}` | `[Paste your rough prompt here]` | The vague prompt to optimize |
| `{{tone_style}}` | `professional` | Desired voice (professional, conversational, playful) |
| `{{target_audience}}` | `general` | Who will read the output (beginner, expert, etc.) |
| `{{output_format}}` | `paragraph` | Desired structure (paragraph, bullets, JSON) |
| `{{length_constraint}}` | `medium` | Output size (brief, short, medium, long) |
| `{{include_examples}}` | `true` | Whether to request examples in output |

## Quick Start Example

After installing, simply paste a rough prompt:

```
write me a blog post about AI
```

The optimizer will return:

```
## Your Optimized Prompt

Write a 1,200-word blog post titled "5 AI Tools That Actually Save Small Business Owners Time" for non-technical small business owners.

Structure:
- Hook: Start with a relatable time-wasting scenario
- 5 tools, each with: name, what it does, specific time saved, cost, one real use case
- Conclusion: 3 questions to ask before adopting any AI tool

Tone: Practical and friendly, like advice from a tech-savvy friend. No hype.
Include: At least 2 specific numbers/statistics.
Avoid: Technical jargon, acronyms without explanation.

## What I Improved

• Added specific word count (1,200)
• Named target audience (non-technical small business owners)
• Specified structure (hook + 5 tools + conclusion format)
• Defined tone (practical, friendly, no hype)
• Added requirements (statistics, real use cases)
• Listed exclusions (jargon, unexplained acronyms)

## Why These Changes Matter

These changes tell the AI exactly what you want, who it's for, and how to structure it—eliminating the guesswork that causes generic outputs.
```

## The 7 Optimization Lenses

The skill analyzes prompts through these lenses:

1. **Specificity & Context** - Adding concrete details
2. **Target Audience** - Defining who will use the output
3. **Output Format** - Specifying structure and length
4. **Tone & Voice** - Guiding style and personality
5. **Constraints** - Setting boundaries and limits
6. **Examples** - Providing anchors for expected output
7. **Role & Expertise** - Assigning persona/perspective

## Works With Any Prompt Type

- Blog posts & articles
- Emails & professional communication
- Code generation
- Social media content
- Analysis & research
- Creative writing
- Business documents

## Related Skills

- **Prompt Debugging Coach**: Diagnose WHY prompts fail
- **10x Your Prompts**: A/B testing and iteration techniques
- **Prompt Engineering Patterns**: Advanced production techniques

---
Downloaded from [Find Skill.ai](https://findskill.ai)
