---
name: impostor-syndrome-reframer
version: 1.0.0
---

# Initialization

Transform self-doubt into authentic confidence using evidence-based cognitive reframing techniques. This skill helps high-achieving individuals identify impostor thoughts, challenge cognitive distortions, and build lasting confidence through documented accomplishment tracking and self-compassion practices.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive impostor syndrome reframing instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r impostor-syndrome-reframer/ ~/.claude/skills/impostor-syndrome-reframer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{thought_intensity_scale}}` | `5` | Rate current impostor feeling intensity (1-10) to tailor intervention depth |
| `{{cognitive_distortion_focus}}` | `multiple` | Specific distortion type to address (catastrophizing, discounting_positive, mind_reading, perfectionism, all_or_nothing, multiple) |
| `{{evidence_requirement_level}}` | `moderate` | Depth of evidence collection (minimal, moderate, rigorous) |
| `{{intervention_style}}` | `balanced` | Approach preference (cognitive_focused, behavioral_focused, compassion_focused, balanced) |
| `{{support_context}}` | `individual` | Working context (individual, peer_group, organizational, team_led) |
| `{{time_constraint}}` | `standard` | Available time for session (quick=5min, standard=15-20min, deep=45+min) |

## Key Features

### Cognitive Distortion Identification
Identifies 12 common distortions fueling impostor feelings:
- Discounting the Positive
- Catastrophizing
- Mind-Reading
- All-or-Nothing Thinking
- Emotional Reasoning
- Perfectionism
- Personalization
- Labeling
- Fortune Telling
- Should Statements
- Magnification
- Filtering

### Evidence-Based Thought Challenging
Seven-step cognitive restructuring process:
1. Capture automatic thought
2. Rate belief strength
3. Identify distortion type
4. Gather evidence FOR thought
5. Gather evidence AGAINST thought
6. Create balanced alternative
7. Re-rate beliefs

### The Impostor Cycle
Helps users break the self-perpetuating pattern:
1. Achievement task appears
2. Self-doubt emerges
3. Over-preparation OR procrastination
4. Task completed
5. Temporary relief
6. Failure to internalize
7. Cycle repeats

### Accomplishment Evidence File
Structured system for documenting competence:
- Situation/Action/Result format
- Weekly review ritual
- Strategic deployment before high-stakes situations

### Self-Compassion Integration
Three-component framework (Kristin Neff):
1. Self-Kindness (vs. Self-Judgment)
2. Common Humanity (vs. Isolation)
3. Mindfulness (vs. Over-Identification)

### Workflows Included
- Quick Reframe Protocol (5 minutes)
- Deep Cognitive Restructuring (20-30 minutes)
- Accomplishment Inventory Session (30 minutes)
- Impostor Cycle Interrupt (15 minutes)
- Team/Peer Impostor Discussion (45 minutes)

## Example Usage

```
User: "I just got promoted to engineering manager, but I feel like a total fraud.
Everyone else seems so confident and prepared. I think the hiring committee made
a mistake. I barely have 2 years of relevant experience and I know there are
people in the organization with way more expertise. What if I make a major
decision that tanks the team?"

The skill will:
1. Validate the promotion anxiety as normal transition experience
2. Identify cognitive distortions (mind-reading, catastrophizing, discounting positive)
3. Gather specific evidence of competence
4. Create balanced reframe with anchor statement
5. Provide action step for immediate application
```

## Research Foundation

Based on peer-reviewed research including:
- Frontiers in Psychology 2024 intervention scoping review
- NIH/NCBI clinical resources on impostor phenomenon
- Clance-Imes original research and cycle model
- CBT and cognitive restructuring evidence base
- Self-compassion research (Kristin Neff framework)
- MIT Sloan organizational psychology research

## Related Skills

- Emotional Regulation Coach
- Assertive Communication Coach
- Mental Wellness Companion
- Stress Management
- Authentic Social Connection Coach
- Salary Negotiation Coach
- Interview Coach

---
Downloaded from [Find Skill.ai](https://findskill.ai)
