---
name: ghost-job-spotter
version: 1.0.0
---

# Ghost Job Spotter - Initialization

Analyze job postings to detect fake "ghost jobs" and resume farming listings. Get probability scores, red flag analysis, and recruiter verification to avoid wasting time on applications that lead nowhere.

## Structure

```
ghost-job-spotter/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r ghost-job-spotter/ ~/.claude/skills/ghost-job-spotter/
```

Then reference in your project's CLAUDE.md:

```markdown
## Available Skills

| Skill | Location | Use When |
|-------|----------|----------|
| ghost-job-spotter | ~/.claude/skills/ghost-job-spotter/ | Analyzing job postings for ghost job indicators |
```

### ChatGPT / Claude.ai / Gemini Installation

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new chat or custom instructions
4. Start analyzing job postings

### Custom GPT Installation

1. Create a new GPT in ChatGPT
2. Name: "Ghost Job Spotter"
3. Description: "Analyze job postings to detect fake ghost jobs and resume farming"
4. Instructions: Paste contents of `SKILL.md` (after frontmatter)
5. Conversation starters:
   - "Analyze this job posting for ghost job indicators"
   - "Is this recruiter legitimate?"
   - "Check if this company is actually hiring"
   - "Compare these 3 job postings"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{posting_age_threshold}}` | `45` | Days before flagging posting as stale |
| `{{salary_deviation_threshold}}` | `25` | Percent salary can deviate from market |
| `{{recruiter_strictness}}` | `moderate` | How strictly to verify recruiters |
| `{{buzzword_sensitivity}}` | `moderate` | How aggressively to flag generic language |
| `{{repost_frequency}}` | `weekly` | Repost detection window |

### Customizing Variables

Replace variable placeholders in SKILL.md with your preferred values:

**For Tech Industry:**
```
posting_age_threshold: 30
salary_deviation_threshold: 20
recruiter_strictness: moderate
```

**For Government/Enterprise:**
```
posting_age_threshold: 90
salary_deviation_threshold: 30
recruiter_strictness: lenient
```

**For Maximum Protection:**
```
posting_age_threshold: 30
salary_deviation_threshold: 15
recruiter_strictness: strict
buzzword_sensitivity: high
```

## Quick Start Examples

### Example 1: Quick Analysis
```
Analyze this job posting: "Senior Data Analyst at TechCorp -
Exciting opportunity for a rockstar analyst! Send resume to
careers@techcorp-recruiting.gmail.com. Posted 52 days ago."
```

### Example 2: Full Investigation
```
Do a comprehensive ghost job analysis on this posting:
[paste full job description]
Company: Acme Inc
Posted: LinkedIn, 3 weeks ago
Recruiter: John Smith (john.smith.talent@gmail.com)
Salary: $180K-$220K
```

### Example 3: Batch Analysis
```
Compare these 3 job postings and rank them by legitimacy:
1. [Job A details]
2. [Job B details]
3. [Job C details]
```

### Example 4: Recruiter Verification
```
Verify this recruiter:
Name: Sarah Chen
Email: sarah.chen@recruiting-pros.com
LinkedIn: linkedin.com/in/sarah-chen-recruiter
Claims to recruit for: Google, Meta, Amazon
```

## Capabilities

1. **Ghost Job Detection** - Multi-factor analysis with probability scoring
2. **Recruiter Verification** - Validate recruiter legitimacy
3. **Company Health Check** - Assess if company is genuinely hiring
4. **Salary Benchmarking** - Compare posted salary to market rates
5. **Batch Analysis** - Evaluate multiple postings at once
6. **Industry-Specific** - Adjusted thresholds for tech, finance, healthcare, government

## Output Formats

The skill provides structured output including:
- Ghost Job Probability (0-100%)
- Factor-by-factor scoring breakdown
- Red flags with evidence
- Clear recommendations (Apply/Skip/Verify)
- Safe next steps

## Troubleshooting

**"Need more information"**
Provide: full job description, posting age, source (Indeed/LinkedIn/etc), and recruiter details if available.

**"False positive on legitimate role"**
Adjust variables: increase `posting_age_threshold` for slower-hiring industries, set `recruiter_strictness` to `lenient` for established staffing agencies.

**"Missed a ghost job"**
Tighten settings: reduce thresholds, set `buzzword_sensitivity` to `high`, use `strict` recruiter verification.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
