---
name: fitness-goal-plan-builder
version: 1.0.0
---

# Initialization

Transform vague fitness aspirations into SMART goals with personalized 12-week periodized training plans. This skill combines goal clarification, evidence-based periodization, and habit stacking for sustainable fitness results.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for goal discovery, 12-week periodized programming, habit integration, baseline assessment, and plateau management

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. Optional integrations:
- Fitness tracking app (for logging workouts)
- Body composition scale (for progress tracking)
- Calendar app (for habit tracking)

## Post-Init Steps

### Claude Code
```bash
cp -r fitness-goal-plan-builder/ ~/.claude/skills/fitness-goal-plan-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the `---`)
3. Paste into your AI assistant as a system prompt or custom instructions

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

Works best with AI assistants that support:
- Long-form conversations
- Multi-turn interactions
- Formatted output (tables, code blocks)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{training_frequency}}` | `4` | Number of training days per week (3-6) |
| `{{primary_goal_priority}}` | `balanced` | Main focus: strength, endurance, body_composition, or balanced |
| `{{fitness_experience_level}}` | `beginner` | Training history: beginner (0-6 mo), intermediate (6-24 mo), advanced (24+ mo) |
| `{{weekly_overload_percentage}}` | `5` | Target weekly progression rate (2-8%) |
| `{{deload_frequency_weeks}}` | `12` | How often to include recovery weeks (4, 6, 8, 10, or 12) |
| `{{habit_anchor_frequency}}` | `daily` | Anchor habit frequency: daily, 5x_per_week, or 3x_per_week |

## Core Capabilities

1. **Goal Discovery & SMART Clarification** - Transform vague goals into specific, measurable targets
2. **12-Week Periodized Plan Generation** - Design phase-based training (Hypertrophy → Strength → Power → Deload)
3. **Habit Integration & Sustainability** - Use habit stacking to embed fitness into daily routines
4. **Baseline Assessment & Progress Tracking** - Establish metrics and checkpoint protocols
5. **Progression & Plateau Management** - Diagnose and resolve training plateaus

## Example Usage

```
"I'm a 32-year-old office worker who sits most of the day. I want to get visibly
stronger (especially bench press and deadlift), lose about 15 lbs of fat, and
build a sustainable habit. I can only commit 4 days/week for 45-minute sessions.
What's my 12-week plan and how do I know if it's working?"
```

## Research Foundation

This skill is based on peer-reviewed research including:
- SMART goal-setting and 12-week training interventions (MDPI 2022)
- Habit formation and behavior change psychology (Oxford Research Encyclopedia)
- Periodization principles and progressive overload (NSCA, Human Kinetics)
- Habit stacking efficacy studies (Trainerize 2025)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
