---
name: financial-independence-calculator
version: 1.0.0
---

# Initialization

A comprehensive FIRE (Financial Independence, Retire Early) calculator that helps users calculate their FIRE number, model retirement timelines, compare different FIRE strategies (Lean, Fat, Coast, Barista), test safe withdrawal rates, and track progress toward financial independence with scenario analysis and sensitivity testing.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive FIRE calculation instructions, formulas, and interactive guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r financial-independence-calculator/ ~/.claude/skills/financial-independence-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Financial Independence...")
3. Paste into your AI assistant as a system prompt or custom instruction

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_annual_income}}` | `60000` | After-tax annual income available for saving |
| `{{annual_retirement_spending}}` | `40000` | Projected annual expenses in retirement |
| `{{current_portfolio_value}}` | `50000` | Total current investments dedicated to retirement |
| `{{investment_return_rate}}` | `0.07` | Expected annual portfolio growth rate (real, inflation-adjusted) |
| `{{safe_withdrawal_rate}}` | `0.04` | Percentage of portfolio withdrawn annually in retirement |
| `{{inflation_rate}}` | `0.025` | Annual inflation assumption for projections |

## Usage Examples

**Basic FIRE Number Calculation:**
> "I spend $40,000 per year. What's my FIRE number?"

**Timeline Projection:**
> "I'm 32, earn $75k after-tax, spend $30k/year, and have $120k invested. When can I retire?"

**Scenario Comparison:**
> "Compare Lean FIRE at $25k/year vs Fat FIRE at $60k/year for my situation."

**Stress Testing:**
> "Test my $1M portfolio with 4% withdrawal against 1970s stagflation and 2008 crash scenarios."

## Key Features

- FIRE number calculation with 25x multiplier
- Year-by-year portfolio projection
- Savings rate impact analysis
- Coast FIRE threshold calculation
- Multiple FIRE variation comparison (Lean/Fat/Coast/Barista)
- Safe withdrawal rate research and recommendations
- Dynamic withdrawal strategies (guardrails approach)
- Milestone tracking and progress visualization
- Sensitivity analysis for returns/savings/spending changes
- Historical worst-case scenario testing

---
Downloaded from [Find Skill.ai](https://findskill.ai)
