---
name: featured-snippet-optimizer
version: 1.0.0
---

# Initialization

Featured Snippet Optimizer helps you win position zero in Google search results by optimizing content structure for featured snippets, analyzing SERP formats, and creating direct-answer content blocks.

## Structure

- `SKILL.md` - Main skill prompt with snippet optimization frameworks, templates, and workflows

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r featured-snippet-optimizer/ ~/.claude/skills/featured-snippet-optimizer/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are a featured snippet...")
3. Paste into your AI assistant as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_keyword}}` | `how to start a blog` | Primary keyword to optimize for featured snippet |
| `{{content_type}}` | `existing article` | Content format (existing article, new content, product page) |
| `{{snippet_type_target}}` | `paragraph` | Featured snippet type to target (paragraph, list, table, video) |
| `{{word_count_limit}}` | `50` | Maximum word count for snippet-optimized answer block |
| `{{competitor_count}}` | `5` | Number of competing snippets to analyze |
| `{{paa_depth}}` | `8` | Number of People Also Ask questions to target |

## Quick Start Examples

### Example 1: Optimize Existing Content

```
I have a 2,000-word article on "how to meal prep for beginners"
that ranks #3. The current featured snippet is a numbered list
from a competitor. Analyze my content and restructure it to
win the snippet.
```

### Example 2: Create Snippet-Optimized Content

```
I want to create new content targeting "best project management
software for small teams". The current snippet is a comparison
table. Help me structure an article that can win this snippet
with a better table format.
```

### Example 3: PAA Domination

```
For my pillar page on "remote work productivity", research the
top 10 People Also Ask questions and create optimized Q&A
sections with FAQ schema markup.
```

## Key Workflows

1. **SERP Analysis**: Analyze current snippet format, competitor content, and weaknesses
2. **Content Restructuring**: Optimize headers, add direct-answer blocks, format lists/tables
3. **PAA Targeting**: Create Q&A sections for People Also Ask opportunities
4. **Snippet Defense**: Monitor, maintain, and strengthen snippets you've won

## Snippet Type Quick Reference

| Query Pattern | Target Format | Optimal Structure |
|--------------|---------------|-------------------|
| What is X | Paragraph | 40-60 word definition |
| How to X | Ordered list | 5-8 numbered steps |
| X vs Y | Table | 3-6 rows, 2-4 columns |
| Best X for Y | Unordered list | 5-8 bullet points |
| Why does X | Paragraph | Explanation block |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
