---
name: feature-prioritization-framework
version: 1.0.0
---

# Feature Prioritization Framework - Initialization

Master RICE, MoSCoW, Kano, and weighted scoring frameworks to prioritize product features. Make data-driven roadmap decisions with stakeholder alignment.

## Structure

- `SKILL.md` - Main skill prompt containing prioritization frameworks and workflows

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r feature-prioritization-framework/ ~/.claude/skills/feature-prioritization-framework/
```

Then reference in your CLAUDE.md:

```markdown
## Available Skills

| Skill | Use When |
|-------|----------|
| `feature-prioritization-framework` | Prioritizing product features, creating roadmaps |
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{prioritization_framework}}` | `RICE` | Primary framework (RICE, MoSCoW, Kano, Weighted Scoring, Value-Effort) |
| `{{feature_count}}` | `8` | Number of features to prioritize in session |
| `{{strategic_weight}}` | `0.25` | Percentage allocated to strategic alignment (0-1) |
| `{{effort_unit}}` | `person-months` | Unit for effort estimation |
| `{{confidence_threshold}}` | `70` | Minimum confidence percentage for RICE |
| `{{max_concurrent_initiatives}}` | `3` | Maximum simultaneous large features |

## Quick Start

After installation, start a prioritization session:

```
I have [N] features to prioritize for next quarter:
1. [Feature A] - [Brief description]
2. [Feature B] - [Brief description]
3. [Feature C] - [Brief description]

Our strategic goals are: [Goal 1], [Goal 2]
Team capacity: [X] person-months

Help me prioritize using RICE scoring.
```

## Framework Selection Guide

| Context | Recommended Framework |
|---------|----------------------|
| Continuous development | RICE |
| Hard deadline release | MoSCoW |
| Customer satisfaction focus | Kano |
| Multi-stakeholder consensus | Weighted Scoring |
| Quick 5-10 feature decision | Value-Effort Matrix |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
