---
name: dropshipping-product-descriptions
version: 1.0.0
---

# Initialization

Create unique, SEO-optimized product descriptions for dropshipping stores. Transform generic supplier copy into conversion-focused listings.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r dropshipping-product-descriptions/ ~/.claude/skills/dropshipping-product-descriptions/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_type}}` | `general consumer product` | Type of product being sold |
| `{{supplier_description}}` | - | Original supplier/AliExpress description to transform |
| `{{target_audience}}` | `online shoppers seeking quality products` | Who is your ideal customer |
| `{{price_point}}` | `mid-range` | Product price range positioning |
| `{{brand_voice}}` | `friendly and trustworthy` | Writing tone and style |
| `{{usp}}` | `quality products with fast shipping` | Unique selling proposition of your store |

---
Downloaded from [Find Skill.ai](https://findskill.ai)