---
name: digital-detox-planner
version: 1.0.0
---

# Initialization

Digital Detox Planner is an AI skill that guides users through sustainable screen-time reduction using behavioral psychology principles, the Transtheoretical Model (TTM), and habit replacement strategies. Unlike cold-turkey approaches (70% failure rate), this skill creates personalized gradual reduction plans with FOMO management, withdrawal coping scripts, and evidence-based habit substitution.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for creating digital detox plans

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r digital-detox-planner/ ~/.claude/skills/digital-detox-planner/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant (ChatGPT, Gemini, Copilot, etc.)
4. Begin by answering the assessment questions the AI asks

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Key Features

- **TTM-Based Assessment**: Identifies user's stage of change (pre-contemplation through maintenance) to match intervention intensity
- **Phased Reduction Plans**: Week-by-week blueprints moving from environment setup through habit consolidation
- **Habit Replacement Design**: Maps screen behaviors to underlying needs (anxiety, boredom, connection) and designs non-digital alternatives
- **FOMO/Withdrawal Management**: Provides coping scripts and timeline predictions for peak withdrawal periods
- **Progress Tracking**: Weekly check-in structure with quantitative metrics and celebration protocols
- **Relapse Recovery**: Compassionate protocols for minor setbacks and major relapses
- **Context Adaptation**: Customized plans for office workers, students, parents, and high-anxiety users

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{reduction_intensity}}` | `gradual_partial` | Speed of reduction: cold_turkey, rapid_2weeks, gradual_monthly, or gradual_partial |
| `{{target_daily_screentime_minutes}}` | `120` | Final daily screen time goal in minutes |
| `{{critical_apps_csv}}` | `email,work_messaging,family_comms` | Comma-separated list of apps that cannot be cut |
| `{{primary_problem_app}}` | `social_media` | Main problem category: social_media, gaming, news_consumption, work_overflow, streaming_content, or mixed |
| `{{withdrawal_risk_level}}` | `moderate` | Expected withdrawal severity: low, moderate, or high |
| `{{accountability_partner_active}}` | `false` | Whether user has external accountability support |

## Research Foundation

This skill is based on peer-reviewed research including:
- 14-study meta-analysis on digital detox and mental health
- RCTs on smartphone screen time reduction
- Transtheoretical Model (TTM) vs Theory of Planned Behavior comparison studies
- Grayscale mode and digital nudge intervention research
- FOMO-R tool effectiveness studies

## Example Usage

```
User: "I'm a marketing manager spending 6-7 hours daily on my phone, mostly Slack, emails, and scrolling Reddit. I can't sleep until midnight. My partner says I'm always on my phone. I tried cold turkey and lasted 2 days. Help me create a plan that works with my job requirements."

AI Response: [Provides assessment report identifying TTM stage (Action), withdrawal risk (Moderate), critical apps (work email, Slack), and creates 4-week phased plan with structured work app check times, Reddit elimination, evening ritual establishment, and coping scripts for Days 2-4 anxiety peak]
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
