---
name: decision-fatigue-coin-flip
version: 1.0.0
---

# Decision Fatigue Coin Flip - Initialization

An AI-powered assistant that makes trivial, low-stakes decisions (meals, outfits, entertainment, task ordering) on behalf of the user, eliminating cognitive overhead and decision paralysis from everyday micro-choices.

## Who This Is For

- **Busy professionals** maintaining morning focus for high-value work
- **ADHD individuals** with executive dysfunction who find simple choices exhausting
- **Maximizers** prone to perfectionism and second-guessing trivial decisions
- **Remote workers** overwhelmed by endless daily micro-decisions
- **Anyone** experiencing decision fatigue who wants to reclaim cognitive bandwidth

## What It Does

1. **Classifies decisions** - Determines if a decision is low-stakes (handle), medium-stakes (clarify first), or high-stakes (redirect to human judgment)
2. **Extracts context** - Analyzes time, weather, budget, mood, energy level, and available options
3. **Generates 3 recommendations** - One primary pick + two "in case" alternatives with brief reasoning
4. **Learns preferences** - Notices patterns over time (Tuesday lighter lunches, comfort food when tired)
5. **Respects scope** - Never makes career, financial, health, or relationship decisions

## Structure

```
decision-fatigue-coin-flip/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### Claude Code / Claude Desktop
```bash
cp -r decision-fatigue-coin-flip/ ~/.claude/skills/decision-fatigue-coin-flip/
```

### ChatGPT / Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "# Decision Fatigue Coin Flip")
3. Paste into Custom Instructions or start a new conversation with the prompt
4. Begin using with phrases like "What should I eat?" or "Help me decide..."

### Claude Projects
1. Create a new Claude Project
2. Paste SKILL.md content into Project Instructions
3. Use the project for all decision-related conversations

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `decision_scope` | `low_stakes_only` | Filter for decision types to handle |
| `recommendation_count` | `3` | How many options to generate |
| `explanation_length` | `brief` | How much reasoning to provide |
| `context_sensitivity` | `0.7` | Weight of context vs. pure preference |
| `exploration_rate` | `0.2` | How often to suggest novel options |

## Example Interactions

**Quick meal decision:**
```
User: "What should I have for lunch? $12 budget, feeling tired"

AI: **Primary:** Poke bowl - quick, light, meets budget
**In Case 1:** Grilled cheese + soup - comfort when tired
**In Case 2:** Leftovers at desk - save the $12

Tap your pick!
```

**Outfit decision:**
```
User: "What should I wear? 28C, video call at 10am"

AI: **Primary:** Light cotton shirt + shorts - breathable, camera-ready
**In Case 1:** Linen pants + tee - more formal if clients join
**In Case 2:** Nice t-shirt only - video calls are waist-up anyway

What feels right?
```

**Out-of-scope handling:**
```
User: "Should I accept this job offer?"

AI: "This is an important decision outside my low-stakes scope. Let me help you think through it instead:
1. What are your top 3 criteria?
2. Which offer best satisfies #1?
3. What would you regret NOT doing?

Recommend journaling these, then discussing with someone who knows your situation."
```

## Key Concepts

- **Decision Fatigue**: Quality of decisions deteriorates after prolonged decision-making
- **Satisficing**: Seeking "good enough" rather than optimal - leads to faster decisions and less regret
- **Maximizing**: Seeking the best option - associated with higher regret despite better objective outcomes
- **Choice Overload**: Feeling overwhelmed when confronted with too many options
- **Analysis Paralysis**: Overthinking prevents action on even trivial choices
- **Executive Dysfunction**: Difficulty initiating decisions, common in ADHD

## Output Format

```
**Primary:** [Recommendation] - [1-2 sentence reason]

**In Case 1:** [Alternative] - [reason]

**In Case 2:** [Backup] - [reason]

[Feedback prompt]
```

Keep responses under 100 words. Speed is the point.

## Customization Ideas

1. **Domain-specific modes**: Create variants for specific domains (meals-only, outfits-only)
2. **Team mode**: Adapt for group decisions with constraint aggregation
3. **Integration with calendars**: Pull context from schedule automatically
4. **Voice-first**: Optimize prompts for voice assistant usage

---
Downloaded from [Find Skill.ai](https://findskill.ai)
