---
name: debt-payoff-strategy-builder
version: 1.0.0
---

# Initialization

Generate optimized debt repayment schedules using Avalanche, Snowball, and Hybrid methods. This skill helps users model refinancing scenarios, balance transfers, and goal-based reverse planning to accelerate their path to debt freedom.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive debt payoff strategy guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r debt-payoff-strategy-builder/ ~/.claude/skills/debt-payoff-strategy-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `debt_list` | `[]` | Array of debts with name, balance, APR, and minimum payment |
| `monthly_payment_budget` | `calculated from minimums` | Total monthly amount available for debt repayment |
| `payoff_method` | `avalanche` | Strategy preference: avalanche, snowball, hybrid, or custom |
| `extra_payment_amount` | `0` | Additional monthly amount beyond minimums |
| `target_payoff_date` | `null` | Desired debt-free date for reverse calculation |
| `motivation_mode` | `balanced` | Focus: balanced, psychological (quick wins), or financial (max savings) |

## Quick Start Example

Provide your debt information in this format:

```
I have [total debt amount] in debt spread across:
- [Debt 1 name]: $[balance] at [APR]% APR, minimum $[amount]/month
- [Debt 2 name]: $[balance] at [APR]% APR, minimum $[amount]/month
- [Debt 3 name]: $[balance] at [APR]% APR, minimum $[amount]/month

My total monthly payment budget is $[amount].

Compare avalanche vs snowball methods and tell me which approach gets me debt-free fastest while saving the most money.
```

## Features

- **Avalanche Method**: Minimize total interest by paying highest-rate debts first
- **Snowball Method**: Build momentum with quick wins by paying smallest debts first
- **Hybrid Strategies**: Cascade, DTI Priority, Emotional Priority methods
- **Goal-Based Planning**: Calculate required payments for target debt-free date
- **Balance Transfer Analysis**: Evaluate 0% APR promotional offers
- **Refinancing Evaluation**: Assess consolidation options
- **Extra Payment Modeling**: Sensitivity tables for additional payment scenarios
- **Month-by-Month Schedules**: Detailed payment plans with milestones

## Recommended Workflow

1. **Gather debt info**: List all debts with balance, APR, and minimum payments
2. **Set budget**: Determine total monthly payment capacity
3. **Choose preference**: Financial optimization vs. psychological momentum
4. **Review comparison**: See both avalanche and snowball side-by-side
5. **Evaluate options**: Consider balance transfers or refinancing if applicable
6. **Get schedule**: Receive month-by-month payment plan
7. **Track progress**: Celebrate milestones at 25%, 50%, 75%, and 100%

---
Downloaded from [Find Skill.ai](https://findskill.ai)
