---
name: customer-advisory-board-facilitator
version: 1.0.0
---

# Customer Advisory Board Facilitator - Initialization

Design, facilitate, and maximize ROI from Customer Advisory Boards. This skill helps you plan strategic discussions, create customer-centric agendas, manage facilitation, and drive actionable outcomes that influence product strategy and corporate direction.

## Skill Structure

```
customer-advisory-board-facilitator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r customer-advisory-board-facilitator/ ~/.claude/skills/customer-advisory-board-facilitator/
```

Then reference in conversations:
```
Use the customer-advisory-board-facilitator skill to help me design a CAB program.
```

### ChatGPT / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI conversation as the system prompt or first message
4. Begin your CAB planning conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{company_name}}` | `Your Company` | Your company or product name |
| `{{cab_size}}` | `12` | Number of CAB members (8-15 optimal) |
| `{{meeting_frequency}}` | `quarterly` | How often CAB meets: monthly, quarterly, semi-annual, annual |
| `{{strategic_focus}}` | `balanced` | Primary focus: product_roadmap, market_strategy, competitive_intel, balanced |
| `{{facilitation_approach}}` | `external_neutral` | Who facilitates: external_neutral, internal_neutral, hybrid |

## Core Capabilities

1. **CAB Program Design** - Create charters, membership criteria, governance structures
2. **Strategic Question Design** - Transform CEO questions into customer-centric discussions using CAB Corollary Method
3. **Meeting Agenda Planning** - Build 1.5-2 day agendas with strategic discussions, breakouts, and interactive exercises
4. **Facilitation Guidance** - Apply 80/20 rule, manage dominant voices, engage quiet members
5. **Action Management** - Create trackers, communicate progress, measure CAB ROI
6. **Troubleshooting** - Address low engagement, stale membership, tactical drift

## Key Concepts

- **CAB Corollary Questions**: Reframe internal strategy questions into customer perspective
- **80/20 Facilitation Rule**: Members speak 80% of time, company speaks 20%
- **Pre-Meeting Interviews**: 30-minute calls with each member to build customer-driven agenda
- **Gamified Prioritization**: Dot voting, Monopoly money, or bracket-style feature ranking
- **Action Tracker**: Document every feedback item with owner, deadline, and status
- **Question Validation Buckets**: Validate known, challenge assumptions, explore unknown

## Example Usage

**Starting a new CAB:**
```
Help me design a Customer Advisory Board for our B2B SaaS company with $15M ARR.
We have 8 enterprise customers willing to participate. Our CEO wants to validate
our platform consolidation strategy and get input on our 2026 product roadmap.
```

**Designing questions:**
```
My CEO wants to know "Should we build or buy our analytics module?"
Help me convert this to CAB-appropriate customer-centric questions.
```

**Planning a meeting:**
```
Create a 1.5-day CAB meeting agenda focused on competitive positioning
and product roadmap. We have 12 members from healthcare and fintech.
```

**Post-meeting follow-up:**
```
Here are the key themes from our CAB meeting. Help me create an action
tracker and member communication plan.
```

## Expected Outputs

When you engage this skill, expect:

- **CAB Charter**: Complete document with mission, objectives, criteria, logistics
- **Discussion Guides**: 5-7 questions with follow-up probes and facilitation notes
- **Meeting Agendas**: Time-boxed sessions with format and purpose
- **Action Trackers**: Categorized feedback with ownership and deadlines
- **Communication Templates**: Invitation letters, summaries, progress updates

## Success Metrics

Well-executed CABs deliver:
- 66.8% sales growth post-CAB vs. 22.9% pre-CAB (BDC study)
- 79% marketing lift from customer advocacy (Forrester)
- Improved retention through executive engagement
- Reduced product missteps through early validation

## Related Skills

- Voice of Customer Analyzer - Analyze feedback from CAB sessions
- Customer Retention Strategy Builder - Build strategies from CAB insights
- Go-To-Market Strategy Creator - Refine GTM based on CAB intelligence
- Competitive Analysis Framework - Structure competitive insights

---
Downloaded from [Find Skill.ai](https://findskill.ai)
