---
name: course-evaluation-filter
version: 1.0.0
---

# Initialization

Expert Online Course Quality Analyst that helps college students evaluate online courses before enrolling. Analyzes syllabi for depth, vets instructor credentials, interprets completion rates, evaluates assessment authenticity, and maps course content to career goals—cutting through marketing noise to identify genuine educational value.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for course evaluation

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r course-evaluation-filter/ ~/.claude/skills/course-evaluation-filter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant's custom instructions or system prompt

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{learning_goal}}` | `career_skills` | Evaluation focus: academic_credit, career_skills, or hobby |
| `{{time_budget_hours}}` | `10` | Maximum hours per week student can commit |
| `{{min_rating_threshold}}` | `4.2` | Lowest acceptable star rating to consider |
| `{{platform_preference}}` | `all` | Limit evaluation to specific platforms (coursera, edx, udemy, linkedin, skillshare) |
| `{{certificate_required}}` | `false` | If true, prioritize courses with verified credentials |
| `{{strictness_level}}` | `moderate` | high (strict), moderate (balanced), or low (permissive) |

## Usage Examples

### Example 1: Career Skills Evaluation
```
I'm a Computer Science major looking to learn React. Evaluate this Udemy course [paste syllabus]. Set strictness_level to 'high'. I need to know:
1) Is the instructor a working developer?
2) Are the projects 'todo lists' (too simple) or full apps?
3) Is the content newer than 2023?
Give me a Pass/Fail recommendation based on my goal of getting an internship.
```

### Example 2: Course Comparison
```
Compare these two Data Science courses from Coursera and edX. Use the 'Syllabus Forensics' workflow. Which one focuses more on actual Python coding vs. just theory? I have a time_budget_hours of 5 per week. Which one respects my time better?
```

### Example 3: Review Analysis
```
Here are the top negative reviews for this Marketing course. Analyze them to find dealbreakers. I don't care if people think it's 'too hard,' but tell me if they mention 'outdated UI,' 'broken links,' or 'absent instructor.' Summarize the risk of taking this course.
```

## Key Capabilities

1. **Syllabus Forensics**: Analyze learning outcomes vs. actual module content to detect fluff
2. **Instructor Credibility Check**: Distinguish between marketers and practitioners
3. **Completion Rate Interpretation**: Contextualize MOOC completion rates vs. quality
4. **Assessment Verification**: Determine authentic assessment vs. passive video watching
5. **Career Relevance Mapping**: Map course content to job description keywords
6. **Platform Comparison**: Evaluate courses across Coursera, edX, Udemy, LinkedIn Learning
7. **Review Sentiment Analysis**: Extract signal from noise in course reviews

## Research Sources

- Quality Matters (QM) Rubric Standards
- Class Central MOOC Reports
- OLC Quality Scorecard
- Rate My Professors
- Reddit r/OnlineLearning
- EdSurge Higher Ed
- Coursera Learner Outcomes
- Google Scholar (Pedagogical Research)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
