---
name: couples-financial-conflict-solver
version: 1.0.0
---

# Initialization

The **Couples Financial Conflict Solver** helps romantic partners navigate money disagreements using evidence-based therapeutic frameworks from the Gottman Method, Financial Therapy, and principled negotiation. Instead of focusing solely on budgeting mechanics, this skill addresses the emotional and relational dimensions of financial conflicts—the values, fears, and dreams that drive each partner's positions.

## What This Skill Does

- **Values Clarification**: Identify what money represents to each partner (security, freedom, legacy, etc.)
- **Fear Exploration**: Uncover anxieties and needs behind financial positions
- **Active Listening**: Guide couples through speaker-listener communication techniques
- **Interest-Based Problem Solving**: Generate solutions honoring both partners' core values
- **Conflict Reframing**: View disagreements as opportunities for deeper connection
- **Money Script Assessment**: Identify limiting beliefs inherited from family patterns
- **Communication Rituals**: Establish ongoing practices for financial harmony

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r couples-financial-conflict-solver/ ~/.claude/skills/couples-financial-conflict-solver/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Key Features

### Core Capabilities
1. **Financial Conflict Assessment** - Identify the 8 core conflict themes and underlying concerns
2. **Values & Beliefs Exploration** - Speaker-Listener protocol for understanding money meanings
3. **Dreams Within Conflict** - Gottman-inspired technique for gridlocked disagreements
4. **Interest-Based Problem Solving** - Fisher & Ury's principled negotiation framework
5. **Constructive Communication** - Reframe destructive patterns (Gottman's Four Horsemen)
6. **Money Script Assessment** - Identify Klontz money scripts (Avoidance, Worship, Status, Vigilance)
7. **Communication Rituals** - Weekly, monthly, quarterly, and annual meeting frameworks

### Key Concepts
- **Dreams Within Conflict**: 69% of couple conflicts are perpetual—manage with respect, not elimination
- **Interests vs. Positions**: Focus on underlying needs, not surface demands
- **Soft Startup**: Initiate difficult conversations without criticism or blame
- **Speaker-Listener Method**: Turn-taking protocol to ensure understanding

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{conflict_intensity}}` | `moderate` | Emotional activation level (low, moderate, high, crisis) |
| `{{relationship_length_years}}` | `7` | How long the couple has been together |
| `{{financial_transparency}}` | `partial` | Degree of openness (full, partial, minimal) |
| `{{communication_style}}` | `mixed` | Baseline pattern (avoidant, constructive, mixed, conflictual) |
| `{{intervention_focus}}` | `holistic` | Priority (understanding, practical, communication, holistic) |
| `{{timeline_to_decision}}` | `flexible` | Urgency (urgent, normal, exploratory) |

## Research Foundation

Based on peer-reviewed research including:
- Gottman Method's Dreams Within Conflict approach
- Fisher & Ury's principled negotiation framework
- Klontz Money Script Inventory (KMSI)
- Financial Therapy Association interventions
- Academic analysis of 1,014+ couple financial conflicts

## Example Usage

**Input**: "My wife and I keep fighting about spending. She wants to save 60% of our income for retirement, but I feel like we should enjoy life now—travel, experiences with our kids. We've had this argument 20 times. She says I'm irresponsible; I say she's controlling."

**What the skill does**:
1. Identifies this as a "Discrepant Values" conflict with fairness/responsibility dimensions
2. Uses Dreams Within Conflict to uncover underlying dreams (security vs. family memories)
3. Reframes from "irresponsible vs. controlling" to "two valid dreams in tension"
4. Generates interest-based options honoring both security AND experiences
5. Creates written agreement with review schedule

---
Downloaded from [Find Skill.ai](https://findskill.ai)
