---
name: college-application-essay-coach
version: 1.0.0
description: Ethical AI coaching for college application essays - brainstorming, outlining, feedback, and polishing without writing for students
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms any AI assistant into an ethical college application essay coach that helps students through the writing process without crossing the line into writing the essay for them.

## Overview

The College Application Essay Coach follows guidelines from leading admissions experts and university policies (including Caltech's ethical AI framework). It helps students brainstorm topics, develop their authentic voice, and refine their own writing.

**Time to initialize**: ~1 minute

## Directory Structure

```
college-application-essay-coach/
├── SKILL.md          # Main skill prompt with coaching framework
└── INIT.md           # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to your AI assistant.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r college-application-essay-coach/ ~/.claude/skills/college-application-essay-coach/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these in conversations:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{essay_type}}` | `Common App personal statement` | Type of college essay |
| `{{word_limit}}` | `650` | Maximum word count |
| `{{prompt_number}}` | `Prompt 7 (topic of choice)` | Essay prompt being answered |
| `{{target_schools}}` | `various selective colleges` | Schools the student is applying to |

## Example Usage

### Brainstorming Stage
```
I'm starting my Common App essay and don't know what to write about.
I like playing video games, cooking, and volunteering at the animal
shelter. Can you help me brainstorm topics?
```

### Outline Stage
```
I want to write about how learning to cook during the pandemic changed me.
Can you help me figure out how to structure this essay?
```

### Draft Feedback
```
Here's my draft for the Common App Prompt 5 essay about personal growth.
Can you give me feedback on what's working and what I should improve?

[paste draft here]
```

### Revision Help
```
My counselor said my essay "tells but doesn't show." I'm not sure what
that means or how to fix it. Can you help?
```

## Ethical Guidelines Built-In

The skill enforces the **Caltech Test**: "Would it be ethical to have a trusted teacher do this same task?"

**Allowed (Coach behavior):**
- Brainstorming topics with the student
- Asking probing questions
- Pointing out weak areas
- Explaining writing principles
- Identifying grammar errors (without fixing)
- Suggesting structural approaches

**Prohibited (Crosses ethical line):**
- Writing any text the student could submit
- Rewriting sentences in "better" words
- Providing copy-paste content
- Creating detailed outlines that are essentially essays
- Generating content from scratch

## Features

- **Discovery Questions**: Probing questions to uncover authentic stories
- **Topic Evaluation**: Criteria for assessing essay topic strength
- **Structure Guidance**: Common essay structures explained (not imposed)
- **Draft Feedback Format**: Systematic feedback without rewriting
- **Revision Guidance**: Questions that lead students to improve their own work
- **Red Flag Detection**: Common pitfalls and coaching responses

## Essay Types Supported

- Common App Personal Statement (650 words)
- Coalition App Essays
- "Why Us?" Supplemental Essays
- Community/Diversity Essays
- Extracurricular Activity Descriptions
- Short Answer Responses
- UC Personal Insight Questions

## Research Basis

This skill incorporates guidelines from:
- Caltech's Ethical Use of AI Policy
- College Essay Guy's AI framework
- Common Sense Media guidance
- Survey data from foundry10 research
- JRA Educational Consulting best practices

---
Downloaded from [Find Skill.ai](https://findskill.ai)
