---
name: cold-email-roaster
version: 1.0.0
---

# Cold Email Roaster - Initialization

An AI diagnostic tool that analyzes cold sales emails and provides brutally honest, actionable feedback on why they get deleted. Uses a 10-dimension scoring framework to identify structural, psychological, and technical problems killing your reply rates.

## Package Contents

```
cold-email-roaster/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This initialization file
```

## Quick Start

### Claude Code Users

```bash
# Copy to your skills directory
cp -r cold-email-roaster/ ~/.claude/skills/cold-email-roaster/
```

Then reference in conversations:
```
Using the cold-email-roaster skill, roast this email:
[paste email]
```

### ChatGPT / Gemini / Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Start a new conversation
4. Paste as system instructions or first message
5. Then paste your cold email to analyze

## How It Works

The skill evaluates emails across 10 dimensions:

| Dimension | What It Checks |
|-----------|----------------|
| Subject Line | Clarity, relevance, spam risk, curiosity |
| Opening Hook | Research signals, specificity, fake vs real personalization |
| Length | Word count (target: <100 words) |
| Recipient Focus | You/I ratio, self-focus detection |
| Value Proposition | Clarity, positioning, benefit visibility |
| Personalization | Authentic research vs template insertions |
| CTA Clarity | Single ask, specificity, pressure level |
| Tone | Human vs corporate robot, formality |
| Psychology | Social proof, reciprocity, curiosity triggers |
| Deliverability | Spam triggers, HTML issues, signature bloat |

Each dimension scores 0-10 points for a total score out of 100.

## Variables

| Variable | Default | Options |
|----------|---------|---------|
| `tone_strictness` | `honest` | `gentle`, `honest`, `savage` |
| `focus_industry` | `B2B SaaS` | `B2B SaaS`, `B2C`, `Recruiting`, `Agency`, `Freelance` |
| `recipient_role` | `decision_maker` | `decision_maker`, `influencer`, `gatekeeper` |
| `email_type` | `cold_outreach` | `cold_outreach`, `follow_up`, `reconnect`, `breakup` |
| `detail_level` | `comprehensive` | `quick_score`, `standard`, `comprehensive` |

## Usage Examples

### Basic Roast

```
Roast this cold email:

Subject: Quick Question

Hi [First Name],

We're a marketing automation platform that helps B2B companies scale their outreach.
I noticed you work at [Company] and thought we might be a good fit.

We've helped companies like Acme Corp increase reply rates by 40%.

Would you be interested in a 15-minute call?

Best,
[Me]
```

### Savage Mode

```
Give me a savage roast of this email (don't hold back):
[paste email]
```

### Subject Line Only

```
Focus on my subject line - give me 5 better alternatives:
Subject: Quick Question
```

### Before/After Comparison

```
I rewrote my email based on your feedback. Compare:

ORIGINAL:
[paste original]

REVISED:
[paste revised]
```

### Batch Audit

```
I'm a sales manager. Score these 5 emails and tell me what patterns my team needs to fix:

Email 1: [paste]
Email 2: [paste]
...
```

## Expected Output

The skill provides:

1. **Overall Score** (X/10) with one-sentence verdict
2. **Dimension Breakdown** - Table with score and issue per dimension
3. **Critical Issues** - Top 2-3 problems with examples from the email
4. **Specific Rewrites** - Before/after for subject line, opening, and CTA
5. **Full Rewrite** - Complete rewritten email with word count
6. **Expected Impact** - Predicted reply rate improvement

## Industry Benchmarks

| Industry | Expected Reply Rate | Ideal Length |
|----------|-------------------|--------------|
| B2B SaaS | 3-6% | 50-90 words |
| Recruiting | 5-8% | 60-100 words |
| Agency | 2-4% | 70-100 words |
| Freelance | 4-7% | 50-80 words |

## Key Principles

**Things the skill will always flag:**

- Subject lines like "Quick Question" or "Checking In"
- Opening with "I" or "We" instead of about them
- Emails over 100 words
- Fake personalization ("I saw you work at [Company]")
- Multiple CTAs ("call OR email OR coffee")
- Corporate speak and buzzwords
- Buried value propositions

**What makes a high-scoring email:**

- Specific research evidence about the recipient
- Lead with THEM, not you
- Under 90 words
- Clear, quantified benefit in first 2 sentences
- Single, specific, low-friction CTA
- Conversational tone

## Troubleshooting

**Skill gives generic feedback:**
- Make sure you're pasting the full email including subject line
- Provide context about your industry and target recipient

**Scores seem harsh:**
- The skill is calibrated to high-performing standards (5-6% reply rate)
- Average cold emails score 3-5/10 - that's normal, not broken

**Want different tone:**
- Specify: "Give me a gentle roast" or "Savage mode, don't hold back"

## Related Skills

- **Cold Email Outreach Pro** - Generate cold emails using proven frameworks
- **Cold Email Sequences** - Build multi-touch email campaigns
- **Sales Copywriting** - Master persuasive writing fundamentals
- **LinkedIn B2B Lead Generation** - Complement emails with LinkedIn

---
Downloaded from [Find Skill.ai](https://findskill.ai)
