---
name: certification-roi-evaluator
version: 1.0.0
---

# Initialization

An AI skill that helps professionals evaluate the true ROI of professional certifications (AWS, PMP, CPA, CISSP, etc.) by quantifying all costs including opportunity cost, projecting realistic salary gains based on context factors, and providing clear go/no-go recommendations with break-even timelines.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive ROI calculation methodology, salary benchmarks, and analysis workflows

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r certification-roi-evaluator/ ~/.claude/skills/certification-roi-evaluator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Certification ROI Analyst...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{certification_type}}` | `AWS Solutions Architect` | The professional certification being evaluated |
| `{{current_salary}}` | `95000` | User's current annual salary in USD |
| `{{years_experience}}` | `5` | Years in current field/role |
| `{{study_hours_estimate}}` | `400` | Expected hours to prepare for exam |
| `{{geographic_location}}` | `United States` | City/region for salary benchmarking |
| `{{discount_rate}}` | `0.03` | Annual discount rate for NPV calculations |

## Core Capabilities

1. **Total Cost Analysis** - Calculate fully-loaded costs including exam fees, courses, materials, and opportunity cost of study time
2. **Salary Impact Forecasting** - Project salary increases using industry benchmarks adjusted for geography, company size, experience, and industry
3. **Break-Even Analysis** - Determine payback period in months
4. **NPV Calculation** - Compute Net Present Value using appropriate discount rates
5. **Certification Comparison** - Side-by-side ROI comparison of multiple certifications
6. **Risk-Adjusted Analysis** - Factor in exam failure rates and certification decay
7. **Career Trajectory Modeling** - Project long-term career and salary impact

## Certification Coverage

### Cloud (AWS, Azure, Google Cloud)
- AWS Solutions Architect (Associate & Professional)
- Azure Administrator
- Google Cloud Professional

### Project Management
- PMP, CAPM, CSM

### Finance/Accounting
- CPA, CFA, CIA

### Cybersecurity
- CISSP, Security+, CEH

## Example Usage

"I'm a Python developer with 6 years of experience earning $95,000/year in Austin, Texas. I want to transition into cloud architecture roles. Should I pursue AWS certification? What's my realistic salary increase and payback timeline?"

---
Downloaded from [Find Skill.ai](https://findskill.ai)
