---
name: career-values-clarifier
version: 1.0.0
---

# Initialization

Career Values Clarifier is an AI-driven career coaching skill that helps individuals identify, prioritize, and align their personal and professional values with career opportunities through structured self-assessment, guided reflection, and values-based decision frameworks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive career values coaching instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r career-values-clarifier/ ~/.claude/skills/career-values-clarifier/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Career Values Clarifier...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{assessment_depth}}` | `comprehensive` | Controls values exploration breadth: quick, standard, or comprehensive |
| `{{values_categories}}` | `all` | Which value types to assess: intrinsic, extrinsic, lifestyle, or all |
| `{{prioritization_method}}` | `forced_choice` | How to narrow values: rating_scale, forced_choice, or ranking |
| `{{career_context}}` | `general` | User's situation: job_search, career_change, role_redesign, or general |
| `{{output_format}}` | `ranked_list` | Values profile format: ranked_list, values_card, or comparison_matrix |

## Core Capabilities

1. **Values Discovery** - Structured self-reflection to reveal intrinsic, extrinsic, and lifestyle values
2. **Values Prioritization** - Narrowing to top 5-8 non-negotiable values using forced-choice methodology
3. **Job-Values Alignment** - Evaluating how well roles match personal values with scoring system
4. **Career Opportunity Comparison** - Values-based decision framework for comparing job offers
5. **Values Conflict Resolution** - Identifying and reconciling competing values (e.g., advancement vs. balance)
6. **Employer Research Guidance** - Assessing organizational culture fit based on values
7. **Career Development Planning** - Creating values-aligned roadmaps with actionable steps

## Example Usage

**Early-Career Professional Feeling Unfulfilled:**
> "I've been in my marketing job for 2 years and feel unfulfilled despite good pay. Help me figure out if I should stay in marketing or try something different."

**Mid-Career Professional Evaluating Offer:**
> "I got an offer from a startup with more money but 60+ hour weeks expected. My kids are 7 and 10. How do I decide?"

**Career Changer Validating Move:**
> "I've been in finance for 8 years and hate the culture. Thinking about nonprofits but worried it's just burnout. How do I know if this will make me happier?"

## Key Frameworks Included

- **Three Values Categories**: Intrinsic (creativity, autonomy, learning), Extrinsic (compensation, status, security), Lifestyle (flexibility, balance, location)
- **Forced Choice Prioritization**: Tournament-style elimination to reveal true priorities
- **Values-Job Alignment Report**: Scoring system with weighted alignment percentage
- **90-Day Values Alignment Plan**: Action planning template for gap closure
- **Values Profile Card**: Visual output format for reference

## Research Foundation

Based on validated methodologies including:
- O*NET Work Values Assessment
- Schwartz Personal Values Questionnaire (SPVQ)
- Career Values Scale (17 work-related values)
- Career Construction Theory
- RIASEC Model for career-values mapping

---
Downloaded from [Find Skill.ai](https://findskill.ai)
