---
name: caffeine-cutoff-calculator
version: 1.0.0
---

# Caffeine Cutoff Calculator - Initialization

A personalized caffeine timing calculator that helps users determine when to stop consuming caffeine based on their bedtime, metabolism profile, and sleep sensitivity.

## Overview

This skill transforms an AI into a sleep scientist and pharmacologist who calculates personalized caffeine cutoff times using pharmacokinetic principles. It accounts for genetic variation in caffeine metabolism (CYP1A2), medication interactions, cumulative daily intake, and individual sleep sensitivity.

## Structure

```
caffeine-cutoff-calculator/
├── SKILL.md          # Main skill prompt (500+ lines)
├── INIT.md           # This initialization file
└── index.md          # Hugo page (for website only)
```

## Files to Generate

None required. This is a prompt-only skill.

## Key Capabilities

1. **Personalized Cutoff Calculation**: Calculate exact cutoff time based on bedtime and metabolism
2. **Cumulative Dose Tracking**: Track multiple caffeine sources throughout the day
3. **Metabolism Profiling**: Account for fast/slow metabolizers and genetic factors
4. **Medication Adjustments**: Modify calculations for oral contraceptives, pregnancy, etc.
5. **Sleep Quality Education**: Explain why even "I sleep fine" may hide quality issues

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{desired_bedtime}}` | `11:00 PM` | User's target sleep time |
| `{{metabolism_profile}}` | `average` | fast, average, slow, or custom |
| `{{sleep_sensitivity}}` | `moderate` | light, moderate, or heavy sleeper |
| `{{medication_modifiers}}` | `none` | Factors affecting metabolism |

## Quick Reference: Half-Life Values

| Profile | Half-Life | Safe Clearance |
|---------|-----------|----------------|
| Fast | 3-4 hours | 6-8 hours before bed |
| Average | 5-6 hours | 8-10 hours before bed |
| Slow | 8-10 hours | 10-12 hours before bed |

## Core Formula

```
Cutoff Time = Bedtime - (Half-Life × Clearance Multiplier)

Clearance Multiplier:
- Light sleeper: 2.0
- Moderate sleeper: 1.5
- Heavy sleeper: 1.2
```

## Post-Init Steps

### Claude Code Installation
```bash
cp -r caffeine-cutoff-calculator/ ~/.claude/skills/caffeine-cutoff-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after second `---`)
3. Paste into your AI assistant as a system prompt or context

### Quick Start Prompts
After installing, try these prompts:

1. "I want to be asleep by 10:30 PM. When should I stop drinking caffeine?"
2. "I had 200mg of coffee at 8 AM. Can I have another at 2 PM if I sleep at 11?"
3. "I'm a slow caffeine metabolizer. Calculate my cutoff for a 9 PM bedtime."

## Caffeine Content Quick Reference

| Beverage | Caffeine (mg) |
|----------|---------------|
| Coffee (8 oz) | 95-200 |
| Espresso (shot) | 63 |
| Black Tea (8 oz) | 40-70 |
| Green Tea (8 oz) | 25-50 |
| Red Bull (8.4 oz) | 80 |
| Pre-Workout | 150-300 |

## Research Foundation

This skill is based on:
- FDA caffeine safety guidelines (400mg/day limit)
- Matthew Walker's sleep research (Why We Sleep)
- CYP1A2 pharmacogenomics studies
- Mayo Clinic caffeine recommendations
- Huberman Lab sleep protocols

## Related Skills

- Sleep Optimizer - General sleep quality improvement
- Sleep Quality Debugger - Clinical sleep issue diagnosis
- Habit Tracker - Building consistent caffeine habits
- Stress Management - Managing factors that compound sleep issues

---
Downloaded from [Find Skill.ai](https://findskill.ai)
